/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.tools.cmd;

import cz.vutbr.fit.layout.api.ArtifactService;
import cz.vutbr.fit.layout.api.ParametrizedOperation;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.api.ServiceManager;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.tools.CliCommand;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="SEGMENT", sortOptions=false, abbreviateSynopsis=true, description={"Performs segmentation on a page"})
public class Segmentator
extends CliCommand
implements Callable<Integer> {
    @CommandLine.Option(order=100, names={"-h", "--help"}, usageHelp=true, description={"print help"})
    protected boolean help;
    @CommandLine.Option(order=1, names={"-m", "--method"}, description={"Segmentation method: ${COMPLETION-CANDIDATES} (${DEFAULT-VALUE})"})
    protected Method method = Method.vips;
    @CommandLine.Option(order=2, names={"-O", "--options"}, paramLabel="KEY=VALUE", split="\\,", splitSynopsisLabel=",", description={"Segmentation method options"})
    protected Map<String, String> sopts;

    @Override
    public Integer call() throws Exception {
        try {
            Page page = this.getCli().getPage();
            if (page == null) {
                this.errNoPage("segmentation");
                return 1;
            }
            AreaTree atree = this.segment(page, this.method, this.sopts);
            this.getCli().setAreaTree(atree);
            System.err.println("  Created: " + atree);
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
        }
        catch (ServiceException e) {
            System.err.println("Rendering failed: " + e.getMessage());
        }
        return 1;
    }

    public AreaTree segment(Page page, Method method, Map<String, String> sopts) {
        String serviceId = "";
        switch (method) {
            case bcs: {
                serviceId = "FitLayout.BCS";
                break;
            }
            case vips: {
                serviceId = "FitLayout.VIPS";
            }
        }
        ParametrizedOperation op = this.getCli().getServiceManager().findParmetrizedService(serviceId);
        System.err.println("Segmentation: " + op);
        if (op != null) {
            if (sopts != null) {
                HashMap<String, String> sparams = new HashMap<String, String>(sopts);
                ServiceManager.setServiceParams((ParametrizedOperation)op, sparams);
            }
            System.err.println("  Params: " + op.getParamString());
            Artifact atree = ((ArtifactService)op).process((Artifact)page);
            return (AreaTree)atree;
        }
        return null;
    }

    public static enum Method {
        vips,
        bcs;

    }
}

