/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.tools.cmd;

import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.Serialization;
import cz.vutbr.fit.layout.tools.CliCommand;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import picocli.CommandLine;

@CommandLine.Command(name="DUMP", sortOptions=false, abbreviateSynopsis=true, description={"Dumps the entire repository to a file"})
public class Dump
extends CliCommand
implements Callable<Integer> {
    @CommandLine.Option(order=100, names={"-h", "--help"}, usageHelp=true, description={"print help"})
    protected boolean help;
    @CommandLine.Option(order=1, names={"-o", "--output-file"}, paramLabel="path", description={"output file path (uses stdout when not specified)"})
    protected File outfile;
    @CommandLine.Option(order=2, names={"-f", "--format"}, paramLabel="format", description={"Output format: ${COMPLETION-CANDIDATES} (${DEFAULT-VALUE})."})
    protected Format format = Format.nquads;

    @Override
    public Integer call() throws Exception {
        try {
            ArtifactRepository repo = this.getCli().getArtifactRepository();
            if (repo == null || !(repo instanceof RDFArtifactRepository)) {
                this.errNoRepo();
                return 2;
            }
            System.err.println("Repository dump");
            OutputStream os = this.outfile == null ? new BufferedOutputStream(System.out) : new FileOutputStream(this.outfile);
            RDFArtifactRepository rdfRepo = (RDFArtifactRepository)repo;
            String mime = Dump.getTypeForFormat(this.format);
            Serialization.statementsToStream((Repository)rdfRepo.getStorage().getRepository(), (OutputStream)os, (String)mime, null, null, null, (Resource[])new Resource[0]);
            return 0;
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return 1;
        }
    }

    public static String getTypeForFormat(Format format) {
        String mime = "application/n-quads";
        switch (format) {
            case nquads: {
                mime = "application/n-quads";
                break;
            }
            case turtle: {
                mime = "text/turtle";
                break;
            }
            case xml: {
                mime = "application/rdf+xml";
                break;
            }
            case ntriples: {
                mime = "application/n-triples";
            }
        }
        return mime;
    }

    public static enum Format {
        xml,
        turtle,
        ntriples,
        nquads;

    }
}

