/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.tools.cmd;

import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.io.ArtifactStreamOutput;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.rdf.AreaModelBuilder;
import cz.vutbr.fit.layout.rdf.BoxModelBuilder;
import cz.vutbr.fit.layout.rdf.DefaultIRIFactory;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.Serialization;
import cz.vutbr.fit.layout.tools.CliCommand;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.concurrent.Callable;
import org.eclipse.rdf4j.model.Model;
import picocli.CommandLine;

@CommandLine.Command(name="EXPORT", sortOptions=false, abbreviateSynopsis=true, description={"Exports the last created artifact (page or area tree)"})
public class Export
extends CliCommand
implements Callable<Integer> {
    @CommandLine.Option(order=100, names={"-h", "--help"}, usageHelp=true, description={"print help"})
    protected boolean help;
    @CommandLine.Option(order=1, names={"-o", "--output-file"}, paramLabel="path", description={"output file path"})
    protected File outfile;
    @CommandLine.Option(order=2, names={"-f", "--format"}, paramLabel="format", description={"Output format: ${COMPLETION-CANDIDATES} (${DEFAULT-VALUE}). png uses a screenshot provided by the renderer (if available), pngi draws the internal page representation."})
    protected Format format = Format.xml;

    @Override
    public Integer call() throws Exception {
        try {
            Artifact a = this.getCli().getLastArtifact();
            if (a == null) {
                this.errNoArtifact("EXPORT");
                return 1;
            }
            System.err.println("Exporting " + a);
            OutputStream os = this.outfile == null ? new BufferedOutputStream(System.out) : new FileOutputStream(this.outfile);
            if (a instanceof Page) {
                this.writeOutput((Page)a, os, this.format);
                if (this.outfile != null) {
                    System.err.println("  Written to " + this.outfile);
                }
            } else if (a instanceof AreaTree) {
                Page page = this.getCli().getPage();
                this.writeOutput((AreaTree)a, page, os, this.format);
                if (this.outfile != null) {
                    System.err.println("  Written to " + this.outfile);
                }
            }
            os.close();
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
        }
        catch (MalformedURLException e) {
            System.err.println("Invalid url: " + e.getMessage());
        }
        catch (ServiceException e) {
            System.err.println("Rendering failed: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        return 1;
    }

    public void writeOutput(Page page, OutputStream os, Format format) throws IOException {
        switch (format) {
            case turtle: {
                this.outputRDF(page, os, "text/turtle");
                break;
            }
            case xml: {
                ArtifactStreamOutput.outputXML((Page)page, (OutputStream)os);
                break;
            }
            case json: {
                ArtifactStreamOutput.outputJSON((Page)page, (OutputStream)os);
                break;
            }
            case html: {
                ArtifactStreamOutput.outputHTML((Page)page, (OutputStream)os);
                break;
            }
            case png: {
                ArtifactStreamOutput.outputPNG((Page)page, (OutputStream)os);
            }
            case pngi: {
                ArtifactStreamOutput.outputPNGi((Page)page, (OutputStream)os);
            }
        }
    }

    public void outputRDF(Page page, OutputStream os, String mimeType) throws IOException {
        BoxModelBuilder builder = new BoxModelBuilder((IRIFactory)new DefaultIRIFactory());
        Model graph = builder.createGraph((Artifact)page);
        Serialization.modelToStream((Model)graph, (OutputStream)os, (String)mimeType);
        os.close();
    }

    public void writeOutput(AreaTree atree, Page page, OutputStream os, Format format) throws IOException {
        switch (format) {
            case turtle: {
                this.outputRDF(atree, os, "text/turtle");
                break;
            }
            case xml: {
                ArtifactStreamOutput.outputXML((AreaTree)atree, (OutputStream)os);
                break;
            }
            case json: {
                ArtifactStreamOutput.outputJSON((AreaTree)atree, (OutputStream)os);
                break;
            }
            case html: {
                ArtifactStreamOutput.outputHTML((AreaTree)atree, (Page)page, (OutputStream)os);
                break;
            }
            case png: {
                ArtifactStreamOutput.outputPNG((AreaTree)atree, (Page)page, (OutputStream)os);
                break;
            }
            case pngi: {
                ArtifactStreamOutput.outputPNGi((AreaTree)atree, (Page)page, (OutputStream)os);
            }
        }
    }

    public void outputRDF(AreaTree atree, OutputStream os, String mimeType) throws IOException {
        AreaModelBuilder builder = new AreaModelBuilder((IRIFactory)new DefaultIRIFactory());
        Model graph = builder.createGraph((Artifact)atree);
        Serialization.modelToStream((Model)graph, (OutputStream)os, (String)mimeType);
        os.close();
    }

    public static enum Format {
        xml,
        json,
        turtle,
        html,
        png,
        pngi;

    }
}

