/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.tools.cmd;

import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.RDFStorage;
import cz.vutbr.fit.layout.tools.CliCommand;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.concurrent.Callable;
import org.eclipse.rdf4j.repository.RepositoryException;
import picocli.CommandLine;

@CommandLine.Command(name="QUERY", sortOptions=false, abbreviateSynopsis=true, description={"Executes a SPARQL SELECT query on the repository and creates a CSV output"}, footer={"The repository must be previously opened using the USE command. The SPARQL query must be specified either by the -q or the -i option."})
public class Query
extends CliCommand
implements Callable<Integer> {
    @CommandLine.Option(order=100, names={"-h", "--help"}, usageHelp=true, description={"print help"})
    protected boolean help;
    @CommandLine.Option(order=1, names={"-q", "--query"}, paramLabel="query", description={"SPARQL query string"})
    protected String query;
    @CommandLine.Option(order=2, names={"-i", "--input-file"}, paramLabel="path", description={"SPARQL input file path"})
    protected File infile;
    @CommandLine.Option(order=3, names={"-o", "--output-file"}, paramLabel="path", description={"output file path"})
    protected File outfile;

    @Override
    public Integer call() throws Exception {
        try {
            String queryStr;
            ArtifactRepository repo = this.getCli().getArtifactRepository();
            if (repo == null || !(repo instanceof RDFArtifactRepository)) {
                this.errNoRepo();
                return 2;
            }
            RDFArtifactRepository rdfRepo = (RDFArtifactRepository)repo;
            RDFStorage storage = rdfRepo.getStorage();
            if (this.infile != null) {
                queryStr = Files.readString(this.infile.toPath());
            } else if (this.query != null) {
                queryStr = this.query;
            } else {
                this.printError("No query specified. Use -q or -i.");
                return 2;
            }
            if (this.outfile != null) {
                FileOutputStream out = new FileOutputStream(this.outfile);
                storage.queryExportCSV(queryStr, (OutputStream)out);
                ((OutputStream)out).close();
                System.err.println("Query result written to " + this.outfile);
            } else {
                storage.queryExportCSV(queryStr, (OutputStream)System.out);
            }
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
        }
        catch (RepositoryException e) {
            System.err.println("Error: " + e.getMessage());
        }
        return 1;
    }
}

