/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsi;

import net.sf.jsi.Spot;

public class Area {
    public float minX;
    public float minY;
    public float maxX;
    public float maxY;

    public Area() {
        this.minX = Float.MAX_VALUE;
        this.minY = Float.MAX_VALUE;
        this.maxX = -3.4028235E38f;
        this.maxY = -3.4028235E38f;
    }

    public Area(float x1, float y1, float x2, float y2) {
        this.set(x1, y1, x2, y2);
    }

    public void set(float x1, float y1, float x2, float y2) {
        this.minX = Math.min(x1, x2);
        this.maxX = Math.max(x1, x2);
        this.minY = Math.min(y1, y2);
        this.maxY = Math.max(y1, y2);
    }

    public void set(Area r) {
        this.minX = r.minX;
        this.minY = r.minY;
        this.maxX = r.maxX;
        this.maxY = r.maxY;
    }

    public Area copy() {
        return new Area(this.minX, this.minY, this.maxX, this.maxY);
    }

    public boolean edgeOverlaps(Area r) {
        return this.minX == r.minX || this.maxX == r.maxX || this.minY == r.minY || this.maxY == r.maxY;
    }

    public boolean intersects(Area r) {
        return this.maxX >= r.minX && this.minX <= r.maxX && this.maxY >= r.minY && this.minY <= r.maxY;
    }

    public static boolean intersects(float r1MinX, float r1MinY, float r1MaxX, float r1MaxY, float r2MinX, float r2MinY, float r2MaxX, float r2MaxY) {
        return r1MaxX >= r2MinX && r1MinX <= r2MaxX && r1MaxY >= r2MinY && r1MinY <= r2MaxY;
    }

    public boolean contains(Area r) {
        return this.maxX >= r.maxX && this.minX <= r.minX && this.maxY >= r.maxY && this.minY <= r.minY;
    }

    public static boolean contains(float r1MinX, float r1MinY, float r1MaxX, float r1MaxY, float r2MinX, float r2MinY, float r2MaxX, float r2MaxY) {
        return r1MaxX >= r2MaxX && r1MinX <= r2MinX && r1MaxY >= r2MaxY && r1MinY <= r2MinY;
    }

    public boolean containedBy(Area r) {
        return r.maxX >= this.maxX && r.minX <= this.minX && r.maxY >= this.maxY && r.minY <= this.minY;
    }

    public float distance(Spot p) {
        float distanceSquared = 0.0f;
        float temp = this.minX - p.x;
        if (temp < 0.0f) {
            temp = p.x - this.maxX;
        }
        if (temp > 0.0f) {
            distanceSquared += temp * temp;
        }
        if ((temp = this.minY - p.y) < 0.0f) {
            temp = p.y - this.maxY;
        }
        if (temp > 0.0f) {
            distanceSquared += temp * temp;
        }
        return (float)Math.sqrt(distanceSquared);
    }

    public static float distance(float minX, float minY, float maxX, float maxY, float pX, float pY) {
        return (float)Math.sqrt(Area.distanceSq(minX, minY, maxX, maxY, pX, pY));
    }

    public static float distanceSq(float minX, float minY, float maxX, float maxY, float pX, float pY) {
        float distanceSqX = 0.0f;
        float distanceSqY = 0.0f;
        if (minX > pX) {
            distanceSqX = minX - pX;
            distanceSqX *= distanceSqX;
        } else if (pX > maxX) {
            distanceSqX = pX - maxX;
            distanceSqX *= distanceSqX;
        }
        if (minY > pY) {
            distanceSqY = minY - pY;
            distanceSqY *= distanceSqY;
        } else if (pY > maxY) {
            distanceSqY = pY - maxY;
            distanceSqY *= distanceSqY;
        }
        return distanceSqX + distanceSqY;
    }

    public float distance(Area r) {
        float leastMax;
        float distanceSquared = 0.0f;
        float greatestMin = Math.max(this.minX, r.minX);
        if (greatestMin > (leastMax = Math.min(this.maxX, r.maxX))) {
            distanceSquared += (greatestMin - leastMax) * (greatestMin - leastMax);
        }
        if ((greatestMin = Math.max(this.minY, r.minY)) > (leastMax = Math.min(this.maxY, r.maxY))) {
            distanceSquared += (greatestMin - leastMax) * (greatestMin - leastMax);
        }
        return (float)Math.sqrt(distanceSquared);
    }

    public float enlargement(Area r) {
        float enlargedArea = (Math.max(this.maxX, r.maxX) - Math.min(this.minX, r.minX)) * (Math.max(this.maxY, r.maxY) - Math.min(this.minY, r.minY));
        return enlargedArea - this.area();
    }

    static float enlargement(float r1MinX, float r1MinY, float r1MaxX, float r1MaxY, float r1Area, float r2MinX, float r2MinY, float r2MaxX, float r2MaxY) {
        float r1r2UnionArea;
        if (r1Area == Float.POSITIVE_INFINITY) {
            return 0.0f;
        }
        if (r2MinX < r1MinX) {
            r1MinX = r2MinX;
        }
        if (r2MinY < r1MinY) {
            r1MinY = r2MinY;
        }
        if (r2MaxX > r1MaxX) {
            r1MaxX = r2MaxX;
        }
        if (r2MaxY > r1MaxY) {
            r1MaxY = r2MaxY;
        }
        if ((r1r2UnionArea = (r1MaxX - r1MinX) * (r1MaxY - r1MinY)) == Float.POSITIVE_INFINITY) {
            return Float.POSITIVE_INFINITY;
        }
        return r1r2UnionArea - r1Area;
    }

    public static float enlargement(float r1MinX, float r1MinY, float r1MaxX, float r1MaxY, float r2MinX, float r2MinY, float r2MaxX, float r2MaxY) {
        float r1Area = (r1MaxX - r1MinX) * (r1MaxY - r1MinY);
        return Area.enlargement(r1MinX, r1MinY, r1MaxX, r1MaxY, r1Area, r2MinX, r2MinY, r2MaxX, r2MaxY);
    }

    public float area() {
        return (this.maxX - this.minX) * (this.maxY - this.minY);
    }

    public static float area(float minX, float minY, float maxX, float maxY) {
        return (maxX - minX) * (maxY - minY);
    }

    public void add(Area r) {
        if (r.minX < this.minX) {
            this.minX = r.minX;
        }
        if (r.maxX > this.maxX) {
            this.maxX = r.maxX;
        }
        if (r.minY < this.minY) {
            this.minY = r.minY;
        }
        if (r.maxY > this.maxY) {
            this.maxY = r.maxY;
        }
    }

    public void add(Spot p) {
        if (p.x < this.minX) {
            this.minX = p.x;
        }
        if (p.x > this.maxX) {
            this.maxX = p.x;
        }
        if (p.y < this.minY) {
            this.minY = p.y;
        }
        if (p.y > this.maxY) {
            this.maxY = p.y;
        }
    }

    public Area union(Area r) {
        Area union = this.copy();
        union.add(r);
        return union;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.maxX);
        result = 31 * result + Float.floatToIntBits(this.maxY);
        result = 31 * result + Float.floatToIntBits(this.minX);
        result = 31 * result + Float.floatToIntBits(this.minY);
        return result;
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof Area) {
            Area r = (Area)o;
            if (this.minX == r.minX && this.minY == r.minY && this.maxX == r.maxX && this.maxY == r.maxY) {
                equals = true;
            }
        }
        return equals;
    }

    public boolean sameObject(Object o) {
        return super.equals(o);
    }

    public String toString() {
        return "(" + this.minX + ", " + this.minY + "), (" + this.maxX + ", " + this.maxY + ")";
    }

    public float width() {
        return this.maxX - this.minX;
    }

    public float height() {
        return this.maxY - this.minY;
    }

    public float aspectRatio() {
        return this.width() / this.height();
    }

    public Spot centre() {
        return new Spot((this.minX + this.maxX) / 2.0f, (this.minY + this.maxY) / 2.0f);
    }
}

