/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsi;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.function.DoublePredicate;

final class FloatArray
implements Externalizable {
    private static final float[] EMPTY = new float[0];
    private float[] _data = EMPTY;
    private int _size = 0;

    public FloatArray() {
        this._data = EMPTY;
    }

    public FloatArray(int size) {
        this._data = size == 0 ? EMPTY : new float[size];
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public int size() {
        return this._size;
    }

    public void reset() {
        this._size = 0;
    }

    public void clear() {
        if (this._data.length > 8) {
            this._data = EMPTY;
        }
        this._size = 0;
    }

    public boolean add(float v) {
        this.push(v);
        return true;
    }

    public void push(float v) {
        if (this._size >= this._data.length) {
            this._data = Arrays.copyOf(this._data, this._size < 8 ? 8 : this._size * 2);
        }
        this._data[this._size++] = v;
    }

    public float peek() throws ArrayIndexOutOfBoundsException {
        return this._data[this._size - 1];
    }

    public float pop() throws ArrayIndexOutOfBoundsException {
        if (this._size == 0) {
            throw new ArrayIndexOutOfBoundsException(-1);
        }
        return this._data[--this._size];
    }

    public float get(int index) throws ArrayIndexOutOfBoundsException {
        if (index >= this._size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this._data[index];
    }

    public float set(int index, float value) throws ArrayIndexOutOfBoundsException {
        if (index >= this._size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        float old = this._data[index];
        this._data[index] = value;
        return old;
    }

    public boolean forEach(DoublePredicate cb) {
        int e = this._size;
        for (int i = 0; i < e; ++i) {
            if (cb.test(this._data[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._size);
        int e = this._size;
        for (int i = 0; i < e; ++i) {
            out.writeFloat(this._data[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this._size = in.readInt();
        this._data = this._size == 0 ? EMPTY : new float[this._size];
        int e = this._size;
        for (int i = 0; i < e; ++i) {
            this._data[i] = in.readFloat();
        }
    }
}

