/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsi;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import net.sf.jsi.AreaCallback;

final class IntArray
implements Externalizable {
    private static final int[] EMPTY = new int[0];
    private int[] _data = EMPTY;
    private int _size = 0;

    public IntArray() {
        this._data = EMPTY;
    }

    public IntArray(int size) {
        this._data = size == 0 ? EMPTY : new int[size];
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public int size() {
        return this._size;
    }

    public void reset() {
        this._size = 0;
    }

    public void clear() {
        if (this._data.length > 8) {
            this._data = EMPTY;
        }
        this._size = 0;
    }

    public boolean add(int v) {
        this.push(v);
        return true;
    }

    public void push(int v) {
        if (this._size >= this._data.length) {
            this._data = Arrays.copyOf(this._data, this._size < 8 ? 8 : this._size * 2);
        }
        this._data[this._size++] = v;
    }

    public int peek() throws ArrayIndexOutOfBoundsException {
        return this._data[this._size - 1];
    }

    public int pop() throws ArrayIndexOutOfBoundsException {
        if (this._size == 0) {
            throw new ArrayIndexOutOfBoundsException(-1);
        }
        return this._data[--this._size];
    }

    public int get(int index) throws ArrayIndexOutOfBoundsException {
        if (index >= this._size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this._data[index];
    }

    public int set(int index, int value) throws ArrayIndexOutOfBoundsException {
        if (index >= this._size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int old = this._data[index];
        this._data[index] = value;
        return old;
    }

    public boolean forEach(AreaCallback cb) {
        int e = this._size;
        for (int i = 0; i < e; ++i) {
            if (cb.processArea(this._data[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._size);
        int e = this._size;
        for (int i = 0; i < e; ++i) {
            out.writeInt(this._data[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this._size = in.readInt();
        this._data = this._size == 0 ? EMPTY : new int[this._size];
        int e = this._size;
        for (int i = 0; i < e; ++i) {
            this._data[i] = in.readInt();
        }
    }
}

