/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jsi.Area;
import net.sf.jsi.AreaCallback;
import net.sf.jsi.IntArray;
import net.sf.jsi.Node;
import net.sf.jsi.RTreeBase;
import net.sf.jsi.SpatialIndex;
import net.sf.jsi.Spot;

public class RTree
extends RTreeBase
implements Serializable {
    private static final long serialVersionUID = 8440068248349540350L;
    private static final Logger log = Logger.getLogger(RTree.class.getName());
    private static final Logger logDel = Logger.getLogger(RTree.class.getName() + "-delete");
    private static final boolean INTERNAL_CONSISTENCY_CHECKING = false;
    private static final int DEFAULT_MAX_NODE_ENTRIES = 50;
    private static final int DEFAULT_MIN_NODE_ENTRIES = 20;
    private static final int ENTRY_STATUS_ASSIGNED = 0;
    private static final int ENTRY_STATUS_UNASSIGNED = 1;
    private final boolean isDebug = log.isLoggable(Level.FINE);
    private final boolean isDebugDel = logDel.isLoggable(Level.FINE);
    final int maxNodeEntries;
    final int minNodeEntries;
    private ArrayList<Node> nodeMap = new ArrayList();
    private final IntArray deletedNodeIds = new IntArray();
    private final byte[] entryStatus;
    private final IntArray parents = new IntArray();
    private final IntArray parentsEntry = new IntArray();
    private int treeHeight = 1;
    private int rootNodeId = 0;
    private int size = 0;

    public RTree() {
        this(null);
    }

    public RTree(Properties props) {
        int max = 50;
        int min = 20;
        if (props != null) {
            max = Integer.parseInt(props.getProperty("MaxNodeEntries", "0"));
            min = Integer.parseInt(props.getProperty("MinNodeEntries", "0"));
            if (max < 2) {
                log.warning("Invalid MaxNodeEntries = " + max + " Resetting to default value of " + 50);
                max = 50;
            }
            if (min < 1 || min > max / 2) {
                log.warning("MinNodeEntries must be between 1 and MaxNodeEntries / 2");
                min = max / 2;
            }
        }
        this.maxNodeEntries = max;
        this.minNodeEntries = min;
        this.entryStatus = new byte[this.maxNodeEntries];
        this.putNode(this.rootNodeId, new Node(this.rootNodeId, 1, this.maxNodeEntries));
        if (this.isDebug) {
            log.fine("init()  MaxNodeEntries = " + this.maxNodeEntries + ", MinNodeEntries = " + this.minNodeEntries);
        }
    }

    public void clear() {
        this.nodeMap.clear();
        this.deletedNodeIds.clear();
        this.parents.clear();
        this.parentsEntry.clear();
        this.treeHeight = 1;
        this.rootNodeId = 0;
        this.size = 0;
        this.putNode(this.rootNodeId, new Node(this.rootNodeId, 1, this.maxNodeEntries));
    }

    public SpatialIndex toIndex() {
        if (this.size == 0) {
            return new SpatialIndex(new ArrayList<Node>(), 0, 0);
        }
        int deleted = this.deletedNodeIds.size();
        while (!this.deletedNodeIds.isEmpty()) {
            int idx = this.deletedNodeIds.pop();
            if (idx >= this.nodeMap.size()) continue;
            this.nodeMap.set(idx, null);
        }
        SpatialIndex result = this.size < 128 || deleted == 0 || deleted < this.size / 10 ? new SpatialIndex(this.nodeMap, this.rootNodeId, this.size) : new SpatialIndex(this.nodeMap, this.rootNodeId, this.size);
        this.nodeMap = new ArrayList();
        this.clear();
        return result;
    }

    public int size() {
        return this.size;
    }

    @Override
    public void nearest(Spot p, AreaCallback v, float furthestDistance) {
        super.nearest(p, v, furthestDistance);
    }

    @Override
    public void nearestNUnsorted(Spot p, AreaCallback v, int count, float furthestDistance) {
        super.nearestNUnsorted(p, v, count, furthestDistance);
    }

    @Override
    public void nearestN(Spot p, AreaCallback v, int count, float furthestDistance) {
        super.nearestN(p, v, count, furthestDistance);
    }

    @Override
    public void intersects(Area r, AreaCallback v) {
        super.intersects(r, v);
    }

    @Override
    public void contains(Area r, AreaCallback v) {
        super.contains(r, v);
    }

    public void add(SpatialIndex tree) {
        for (Node n : tree.nodes) {
            if (n == null || !n.isLeaf()) continue;
            for (int i = 0; i < n.entryCount; ++i) {
                this.add(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], n.ids[i], 1);
                ++this.size;
            }
        }
    }

    public void add(Area r, int id) {
        if (this.isDebug) {
            log.fine("Adding rectangle " + r + ", id " + id);
        }
        this.add(r.minX, r.minY, r.maxX, r.maxY, id, 1);
        ++this.size;
    }

    public boolean delete(Area r, int id) {
        this.parents.reset();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.reset();
        this.parentsEntry.push(-1);
        Node n = null;
        int foundIndex = -1;
        while (foundIndex == -1 && this.parents.size() > 0) {
            n = this.getNode(this.parents.peek());
            int startIndex = this.parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                if (this.isDebugDel) {
                    logDel.fine("searching node " + n.nodeId + ", from index " + startIndex);
                }
                boolean contains = false;
                for (int i = startIndex; i < n.entryCount; ++i) {
                    if (!Area.contains(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], r.minX, r.minY, r.maxX, r.maxY)) continue;
                    this.parents.push(n.ids[i]);
                    this.parentsEntry.pop();
                    this.parentsEntry.push(i);
                    this.parentsEntry.push(-1);
                    contains = true;
                    break;
                }
                if (contains) {
                    continue;
                }
            } else {
                foundIndex = n.findEntry(r.minX, r.minY, r.maxX, r.maxY, id);
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
        if (foundIndex != -1 && n != null) {
            n.deleteEntry(foundIndex);
            this.condenseTree(n);
            --this.size;
        }
        Node root = this.getNode(this.rootNodeId);
        while (root.entryCount == 1 && this.treeHeight > 1) {
            this.removeNode(this.rootNodeId);
            root.entryCount = 0;
            this.rootNodeId = root.ids[0];
            --this.treeHeight;
            root = this.getNode(this.rootNodeId);
        }
        if (this.size == 0) {
            root.mbrMinX = Float.MAX_VALUE;
            root.mbrMinY = Float.MAX_VALUE;
            root.mbrMaxX = -3.4028235E38f;
            root.mbrMaxY = -3.4028235E38f;
        }
        return foundIndex != -1;
    }

    private void add(float minX, float minY, float maxX, float maxY, int id, int level) {
        Node n = this.chooseNode(minX, minY, maxX, maxY, level);
        Node newLeaf = null;
        if (n.entryCount < this.maxNodeEntries) {
            n.addEntry(minX, minY, maxX, maxY, id);
        } else {
            newLeaf = this.splitNode(n, minX, minY, maxX, maxY, id);
        }
        Node newNode = this.adjustTree(n, newLeaf);
        if (newNode != null) {
            Node oldRoot = this.getNode(this.rootNodeId);
            this.rootNodeId = this.getNextNodeId();
            ++this.treeHeight;
            Node root = new Node(this.rootNodeId, this.treeHeight, this.maxNodeEntries);
            root.addEntry(newNode.mbrMinX, newNode.mbrMinY, newNode.mbrMaxX, newNode.mbrMaxY, newNode.nodeId);
            root.addEntry(oldRoot.mbrMinX, oldRoot.mbrMinY, oldRoot.mbrMaxX, oldRoot.mbrMaxY, oldRoot.nodeId);
            this.putNode(this.rootNodeId, root);
        }
    }

    private Node splitNode(Node n, float newRectMinX, float newRectMinY, float newRectMaxX, float newRectMaxY, int newId) {
        float initialArea = 0.0f;
        if (this.isDebug) {
            float unionMinX = Math.min(n.mbrMinX, newRectMinX);
            float unionMinY = Math.min(n.mbrMinY, newRectMinY);
            float unionMaxX = Math.max(n.mbrMaxX, newRectMaxX);
            float unionMaxY = Math.max(n.mbrMaxY, newRectMaxY);
            initialArea = (unionMaxX - unionMinX) * (unionMaxY - unionMinY);
        }
        Arrays.fill(this.entryStatus, (byte)1);
        Node newNode = null;
        newNode = new Node(this.getNextNodeId(), n.level, this.maxNodeEntries);
        this.putNode(newNode.nodeId, newNode);
        this.pickSeeds(n, newRectMinX, newRectMinY, newRectMaxX, newRectMaxY, newId, newNode);
        while (n.entryCount + newNode.entryCount < this.maxNodeEntries + 1) {
            if (this.maxNodeEntries + 1 - newNode.entryCount == this.minNodeEntries) {
                for (int i = 0; i < this.maxNodeEntries; ++i) {
                    if (this.entryStatus[i] != 1) continue;
                    this.entryStatus[i] = 0;
                    if (n.entriesMinX[i] < n.mbrMinX) {
                        n.mbrMinX = n.entriesMinX[i];
                    }
                    if (n.entriesMinY[i] < n.mbrMinY) {
                        n.mbrMinY = n.entriesMinY[i];
                    }
                    if (n.entriesMaxX[i] > n.mbrMaxX) {
                        n.mbrMaxX = n.entriesMaxX[i];
                    }
                    if (n.entriesMaxY[i] > n.mbrMaxY) {
                        n.mbrMaxY = n.entriesMaxY[i];
                    }
                    ++n.entryCount;
                }
                break;
            }
            if (this.maxNodeEntries + 1 - n.entryCount == this.minNodeEntries) {
                for (int i = 0; i < this.maxNodeEntries; ++i) {
                    if (this.entryStatus[i] != 1) continue;
                    this.entryStatus[i] = 0;
                    newNode.addEntry(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], n.ids[i]);
                    n.ids[i] = -1;
                }
                break;
            }
            this.pickNext(n, newNode);
        }
        n.reorganize(this);
        if (this.isDebug) {
            float newArea = Area.area(n.mbrMinX, n.mbrMinY, n.mbrMaxX, n.mbrMaxY) + Area.area(newNode.mbrMinX, newNode.mbrMinY, newNode.mbrMaxX, newNode.mbrMaxY);
            float percentageIncrease = 100.0f * (newArea - initialArea) / initialArea;
            log.fine("Node " + n.nodeId + " split. New area increased by " + percentageIncrease + "%");
        }
        return newNode;
    }

    private void pickSeeds(Node n, float newRectMinX, float newRectMinY, float newRectMaxX, float newRectMaxY, int newId, Node newNode) {
        float normalizedSeparation;
        float tempHigh;
        float tempLow;
        int i;
        float maxNormalizedSeparation = -1.0f;
        int highestLowIndex = -1;
        int lowestHighIndex = -1;
        if (newRectMinX < n.mbrMinX) {
            n.mbrMinX = newRectMinX;
        }
        if (newRectMinY < n.mbrMinY) {
            n.mbrMinY = newRectMinY;
        }
        if (newRectMaxX > n.mbrMaxX) {
            n.mbrMaxX = newRectMaxX;
        }
        if (newRectMaxY > n.mbrMaxY) {
            n.mbrMaxY = newRectMaxY;
        }
        float mbrLenX = n.mbrMaxX - n.mbrMinX;
        float mbrLenY = n.mbrMaxY - n.mbrMinY;
        if (this.isDebug) {
            log.fine("pickSeeds(): NodeId = " + n.nodeId);
        }
        float tempHighestLow = newRectMinX;
        int tempHighestLowIndex = -1;
        float tempLowestHigh = newRectMaxX;
        int tempLowestHighIndex = -1;
        for (i = 0; i < n.entryCount; ++i) {
            tempLow = n.entriesMinX[i];
            if (tempLow >= tempHighestLow) {
                tempHighestLow = tempLow;
                tempHighestLowIndex = i;
            } else {
                tempHigh = n.entriesMaxX[i];
                if (tempHigh <= tempLowestHigh) {
                    tempLowestHigh = tempHigh;
                    tempLowestHighIndex = i;
                }
            }
            float f = normalizedSeparation = mbrLenX == 0.0f ? 1.0f : (tempHighestLow - tempLowestHigh) / mbrLenX;
            if (normalizedSeparation > 1.0f || normalizedSeparation < -1.0f) {
                log.severe("Invalid normalized separation X");
            }
            if (this.isDebug) {
                log.fine("Entry " + i + ", dimension X: HighestLow = " + tempHighestLow + " (index " + tempHighestLowIndex + "), LowestHigh = " + tempLowestHigh + " (index " + tempLowestHighIndex + ", NormalizedSeparation = " + normalizedSeparation);
            }
            if (!(normalizedSeparation >= maxNormalizedSeparation)) continue;
            highestLowIndex = tempHighestLowIndex;
            lowestHighIndex = tempLowestHighIndex;
            maxNormalizedSeparation = normalizedSeparation;
        }
        tempHighestLow = newRectMinY;
        tempHighestLowIndex = -1;
        tempLowestHigh = newRectMaxY;
        tempLowestHighIndex = -1;
        for (i = 0; i < n.entryCount; ++i) {
            tempLow = n.entriesMinY[i];
            if (tempLow >= tempHighestLow) {
                tempHighestLow = tempLow;
                tempHighestLowIndex = i;
            } else {
                tempHigh = n.entriesMaxY[i];
                if (tempHigh <= tempLowestHigh) {
                    tempLowestHigh = tempHigh;
                    tempLowestHighIndex = i;
                }
            }
            float f = normalizedSeparation = mbrLenY == 0.0f ? 1.0f : (tempHighestLow - tempLowestHigh) / mbrLenY;
            if (normalizedSeparation > 1.0f || normalizedSeparation < -1.0f) {
                log.severe("Invalid normalized separation Y");
            }
            if (this.isDebug) {
                log.fine("Entry " + i + ", dimension Y: HighestLow = " + tempHighestLow + " (index " + tempHighestLowIndex + "), LowestHigh = " + tempLowestHigh + " (index " + tempLowestHighIndex + ", NormalizedSeparation = " + normalizedSeparation);
            }
            if (!(normalizedSeparation >= maxNormalizedSeparation)) continue;
            highestLowIndex = tempHighestLowIndex;
            lowestHighIndex = tempLowestHighIndex;
            maxNormalizedSeparation = normalizedSeparation;
        }
        if (highestLowIndex == lowestHighIndex) {
            highestLowIndex = -1;
            lowestHighIndex = 0;
            float tempMinY = newRectMinY;
            float tempMaxX = n.entriesMaxX[0];
            for (int i2 = 1; i2 < n.entryCount; ++i2) {
                if (n.entriesMinY[i2] < tempMinY) {
                    tempMinY = n.entriesMinY[i2];
                    highestLowIndex = i2;
                    continue;
                }
                if (!(n.entriesMaxX[i2] > tempMaxX)) continue;
                tempMaxX = n.entriesMaxX[i2];
                lowestHighIndex = i2;
            }
        }
        if (highestLowIndex == -1) {
            newNode.addEntry(newRectMinX, newRectMinY, newRectMaxX, newRectMaxY, newId);
        } else {
            newNode.addEntry(n.entriesMinX[highestLowIndex], n.entriesMinY[highestLowIndex], n.entriesMaxX[highestLowIndex], n.entriesMaxY[highestLowIndex], n.ids[highestLowIndex]);
            n.ids[highestLowIndex] = -1;
            n.entriesMinX[highestLowIndex] = newRectMinX;
            n.entriesMinY[highestLowIndex] = newRectMinY;
            n.entriesMaxX[highestLowIndex] = newRectMaxX;
            n.entriesMaxY[highestLowIndex] = newRectMaxY;
            n.ids[highestLowIndex] = newId;
        }
        if (lowestHighIndex == -1) {
            lowestHighIndex = highestLowIndex;
        }
        this.entryStatus[lowestHighIndex] = 0;
        n.entryCount = 1;
        n.mbrMinX = n.entriesMinX[lowestHighIndex];
        n.mbrMinY = n.entriesMinY[lowestHighIndex];
        n.mbrMaxX = n.entriesMaxX[lowestHighIndex];
        n.mbrMaxY = n.entriesMaxY[lowestHighIndex];
    }

    private int pickNext(Node n, Node newNode) {
        float maxDifference = Float.NEGATIVE_INFINITY;
        int next = 0;
        boolean nextGroup = false;
        maxDifference = Float.NEGATIVE_INFINITY;
        if (this.isDebug) {
            log.fine("pickNext()");
        }
        float rn = Area.area(n.mbrMinX, n.mbrMinY, n.mbrMaxX, n.mbrMaxY);
        float rnn = Area.area(newNode.mbrMinX, newNode.mbrMinY, newNode.mbrMaxX, newNode.mbrMaxY);
        for (int i = 0; i < this.maxNodeEntries; ++i) {
            float newNodeIncrease;
            float nIncrease;
            float difference;
            if (this.entryStatus[i] != 1) continue;
            if (n.ids[i] == -1) {
                log.severe("Error: Node " + n.nodeId + ", entry " + i + " is null");
            }
            if ((difference = Math.abs((nIncrease = Area.enlargement(n.mbrMinX, n.mbrMinY, n.mbrMaxX, n.mbrMaxY, rn, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i])) - (newNodeIncrease = Area.enlargement(newNode.mbrMinX, newNode.mbrMinY, newNode.mbrMaxX, newNode.mbrMaxY, rnn, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i])))) > maxDifference) {
                next = i;
                nextGroup = nIncrease < newNodeIncrease ? false : (newNodeIncrease < nIncrease ? true : (rn < rnn ? false : (rnn < rn ? true : newNode.entryCount >= this.maxNodeEntries / 2)));
                maxDifference = difference;
            }
            if (!this.isDebug) continue;
            log.fine("Entry " + i + " group0 increase = " + nIncrease + ", group1 increase = " + newNodeIncrease + ", diff = " + difference + ", MaxDiff = " + maxDifference + " (entry " + next + ")");
        }
        this.entryStatus[next] = 0;
        if (!nextGroup) {
            if (n.entriesMinX[next] < n.mbrMinX) {
                n.mbrMinX = n.entriesMinX[next];
            }
            if (n.entriesMinY[next] < n.mbrMinY) {
                n.mbrMinY = n.entriesMinY[next];
            }
            if (n.entriesMaxX[next] > n.mbrMaxX) {
                n.mbrMaxX = n.entriesMaxX[next];
            }
            if (n.entriesMaxY[next] > n.mbrMaxY) {
                n.mbrMaxY = n.entriesMaxY[next];
            }
            ++n.entryCount;
        } else {
            newNode.addEntry(n.entriesMinX[next], n.entriesMinY[next], n.entriesMaxX[next], n.entriesMaxY[next], n.ids[next]);
            n.ids[next] = -1;
        }
        return next;
    }

    private void condenseTree(Node l) {
        Node n = l;
        Node parent = null;
        int parentEntry = 0;
        IntArray eliminatedNodeIds = new IntArray();
        while (n.level != this.treeHeight) {
            parent = this.getNode(this.parents.pop());
            parentEntry = this.parentsEntry.pop();
            if (n.entryCount < this.minNodeEntries) {
                parent.deleteEntry(parentEntry);
                eliminatedNodeIds.push(n.nodeId);
            } else if (n.mbrMinX != parent.entriesMinX[parentEntry] || n.mbrMinY != parent.entriesMinY[parentEntry] || n.mbrMaxX != parent.entriesMaxX[parentEntry] || n.mbrMaxY != parent.entriesMaxY[parentEntry]) {
                float deletedMinX = parent.entriesMinX[parentEntry];
                parent.entriesMinX[parentEntry] = n.mbrMinX;
                float deletedMinY = parent.entriesMinY[parentEntry];
                parent.entriesMinY[parentEntry] = n.mbrMinY;
                float deletedMaxX = parent.entriesMaxX[parentEntry];
                parent.entriesMaxX[parentEntry] = n.mbrMaxX;
                float deletedMaxY = parent.entriesMaxY[parentEntry];
                parent.entriesMaxY[parentEntry] = n.mbrMaxY;
                parent.recalculateMBRIfInfluencedBy(deletedMinX, deletedMinY, deletedMaxX, deletedMaxY);
            }
            n = parent;
        }
        while (eliminatedNodeIds.size() > 0) {
            Node e = this.getNode(eliminatedNodeIds.pop());
            for (int j = 0; j < e.entryCount; ++j) {
                this.add(e.entriesMinX[j], e.entriesMinY[j], e.entriesMaxX[j], e.entriesMaxY[j], e.ids[j], e.level);
                e.ids[j] = -1;
            }
            e.entryCount = 0;
            this.removeNode(e.nodeId);
        }
    }

    private Node chooseNode(float minX, float minY, float maxX, float maxY, int level) {
        Node n = this.getNode(this.rootNodeId);
        this.parents.reset();
        this.parentsEntry.reset();
        while (true) {
            if (n == null) {
                log.severe("Could not get root node (" + this.rootNodeId + ")");
            }
            if (n.level == level) {
                return n;
            }
            float areaNIndex = Area.area(n.entriesMinX[0], n.entriesMinY[0], n.entriesMaxX[0], n.entriesMaxY[0]);
            float leastEnlargement = Area.enlargement(n.entriesMinX[0], n.entriesMinY[0], n.entriesMaxX[0], n.entriesMaxY[0], areaNIndex, minX, minY, maxX, maxY);
            int index = 0;
            for (int i = 1; i < n.entryCount; ++i) {
                float tempMinX = n.entriesMinX[i];
                float tempMinY = n.entriesMinY[i];
                float tempMaxX = n.entriesMaxX[i];
                float tempMaxY = n.entriesMaxY[i];
                float tempArea = Area.area(tempMinX, tempMinY, tempMaxX, tempMaxY);
                float tempEnlargement = Area.enlargement(tempMinX, tempMinY, tempMaxX, tempMaxY, tempArea, minX, minY, maxX, maxY);
                if (!(tempEnlargement < leastEnlargement) && (tempEnlargement != leastEnlargement || !(tempArea < areaNIndex))) continue;
                index = i;
                areaNIndex = tempArea;
                leastEnlargement = tempEnlargement;
            }
            this.parents.push(n.nodeId);
            this.parentsEntry.push(index);
            n = this.getNode(n.ids[index]);
        }
    }

    private Node adjustTree(Node n, Node nn) {
        while (n.level != this.treeHeight) {
            Node parent = this.getNode(this.parents.pop());
            int entry = this.parentsEntry.pop();
            if (parent.ids[entry] != n.nodeId) {
                log.severe("Error: entry " + entry + " in node " + parent.nodeId + " should point to node " + n.nodeId + "; actually points to node " + parent.ids[entry]);
            }
            if (parent.entriesMinX[entry] != n.mbrMinX || parent.entriesMinY[entry] != n.mbrMinY || parent.entriesMaxX[entry] != n.mbrMaxX || parent.entriesMaxY[entry] != n.mbrMaxY) {
                parent.entriesMinX[entry] = n.mbrMinX;
                parent.entriesMinY[entry] = n.mbrMinY;
                parent.entriesMaxX[entry] = n.mbrMaxX;
                parent.entriesMaxY[entry] = n.mbrMaxY;
                parent.recalculateMBR();
            }
            Node newNode = null;
            if (nn != null) {
                if (parent.entryCount < this.maxNodeEntries) {
                    parent.addEntry(nn.mbrMinX, nn.mbrMinY, nn.mbrMaxX, nn.mbrMaxY, nn.nodeId);
                } else {
                    newNode = this.splitNode(parent, nn.mbrMinX, nn.mbrMinY, nn.mbrMaxX, nn.mbrMaxY, nn.nodeId);
                }
            }
            n = parent;
            nn = newNode;
            parent = null;
            newNode = null;
        }
        return nn;
    }

    private Area calculateMBR(Node n) {
        Area mbr = new Area();
        for (int i = 0; i < n.entryCount; ++i) {
            if (n.entriesMinX[i] < mbr.minX) {
                mbr.minX = n.entriesMinX[i];
            }
            if (n.entriesMinY[i] < mbr.minY) {
                mbr.minY = n.entriesMinY[i];
            }
            if (n.entriesMaxX[i] > mbr.maxX) {
                mbr.maxX = n.entriesMaxX[i];
            }
            if (!(n.entriesMaxY[i] > mbr.maxY)) continue;
            mbr.maxY = n.entriesMaxY[i];
        }
        return mbr;
    }

    public boolean checkConsistency() {
        return this.checkConsistency(this.rootNodeId, this.treeHeight, null);
    }

    private boolean checkConsistency(int nodeId, int expectedLevel, Area expectedMBR) {
        Node n = this.getNode(nodeId);
        if (n == null) {
            log.severe("Error: Could not read node " + nodeId);
            return false;
        }
        if (nodeId == this.rootNodeId && this.size() == 0 && n.level != 1) {
            log.severe("Error: tree is empty but root node is not at level 1");
            return false;
        }
        if (n.level != expectedLevel) {
            log.severe("Error: Node " + nodeId + ", expected level " + expectedLevel + ", actual level " + n.level);
            return false;
        }
        Area calculatedMBR = this.calculateMBR(n);
        Area actualMBR = new Area();
        actualMBR.minX = n.mbrMinX;
        actualMBR.minY = n.mbrMinY;
        actualMBR.maxX = n.mbrMaxX;
        actualMBR.maxY = n.mbrMaxY;
        if (!actualMBR.equals(calculatedMBR)) {
            log.severe("Error: Node " + nodeId + ", calculated MBR does not equal stored MBR");
            if (actualMBR.minX != n.mbrMinX) {
                log.severe("  actualMinX=" + actualMBR.minX + ", calc=" + calculatedMBR.minX);
            }
            if (actualMBR.minY != n.mbrMinY) {
                log.severe("  actualMinY=" + actualMBR.minY + ", calc=" + calculatedMBR.minY);
            }
            if (actualMBR.maxX != n.mbrMaxX) {
                log.severe("  actualMaxX=" + actualMBR.maxX + ", calc=" + calculatedMBR.maxX);
            }
            if (actualMBR.maxY != n.mbrMaxY) {
                log.severe("  actualMaxY=" + actualMBR.maxY + ", calc=" + calculatedMBR.maxY);
            }
            return false;
        }
        if (expectedMBR != null && !actualMBR.equals(expectedMBR)) {
            log.severe("Error: Node " + nodeId + ", expected MBR (from parent) does not equal stored MBR");
            return false;
        }
        if (expectedMBR != null && actualMBR.sameObject(expectedMBR)) {
            log.severe("Error: Node " + nodeId + " MBR using same rectangle object as parent's entry");
            return false;
        }
        for (int i = 0; i < n.entryCount; ++i) {
            if (n.ids[i] == -1) {
                log.severe("Error: Node " + nodeId + ", Entry " + i + " is null");
                return false;
            }
            if (n.level <= 1 || this.checkConsistency(n.ids[i], n.level - 1, new Area(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int getRoodNodeId() {
        return this.rootNodeId;
    }

    @Override
    protected Node getNode(int id) {
        return id < 0 || id >= this.nodeMap.size() ? null : this.nodeMap.get(id);
    }

    private int getNextNodeId() {
        return this.deletedNodeIds.isEmpty() ? this.nodeMap.size() : this.deletedNodeIds.pop();
    }

    private void putNode(int id, Node node) {
        if (id == this.nodeMap.size()) {
            this.nodeMap.add(node);
        } else {
            this.nodeMap.set(id, node);
        }
    }

    private void removeNode(int id) {
        this.deletedNodeIds.push(id);
    }
}

