/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsi;

import net.sf.jsi.Area;
import net.sf.jsi.AreaCallback;
import net.sf.jsi.IntArray;
import net.sf.jsi.Node;
import net.sf.jsi.PriorityQueue;
import net.sf.jsi.Spot;

abstract class RTreeBase {
    protected RTreeBase() {
    }

    protected abstract int getRoodNodeId();

    protected abstract Node getNode(int var1);

    protected Area getBounds() {
        Area bounds = null;
        Node n = this.getNode(this.getRoodNodeId());
        if (n != null && n.entryCount > 0) {
            bounds = new Area();
            bounds.minX = n.mbrMinX;
            bounds.minY = n.mbrMinY;
            bounds.maxX = n.mbrMaxX;
            bounds.maxY = n.mbrMaxY;
        }
        return bounds;
    }

    protected void nearest(Spot p, AreaCallback v, float furthestDistance) {
        Node rootNode = this.getNode(this.getRoodNodeId());
        float furthestDistanceSq = furthestDistance * furthestDistance;
        IntArray nearestIds = new IntArray();
        this.nearest(p, rootNode, furthestDistanceSq, nearestIds);
        nearestIds.forEach(v);
    }

    protected void nearestNUnsorted(Spot p, AreaCallback v, int count, float furthestDistance) {
        PriorityQueue distanceQueue = new PriorityQueue(false);
        this.createNearestNDistanceQueue(p, count, distanceQueue, furthestDistance);
        while (distanceQueue.size() > 0) {
            v.processArea(distanceQueue.getValue());
            distanceQueue.pop();
        }
    }

    protected void nearestN(Spot p, AreaCallback v, int count, float furthestDistance) {
        PriorityQueue distanceQueue = new PriorityQueue(false);
        this.createNearestNDistanceQueue(p, count, distanceQueue, furthestDistance);
        distanceQueue.setSortOrder(true);
        while (distanceQueue.size() > 0) {
            v.processArea(distanceQueue.getValue());
            distanceQueue.pop();
        }
    }

    protected void intersects(Area r, AreaCallback v) {
        Node rootNode = this.getNode(this.getRoodNodeId());
        this.intersects(r, v, rootNode);
    }

    protected void contains(Area r, AreaCallback v) {
        IntArray parents = new IntArray();
        parents.push(this.getRoodNodeId());
        IntArray parentsEntry = new IntArray();
        parentsEntry.push(-1);
        block0: while (parents.size() > 0) {
            int i;
            Node n = this.getNode(parents.peek());
            int startIndex = parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                for (i = startIndex; i < n.entryCount; ++i) {
                    if (!Area.intersects(r.minX, r.minY, r.maxX, r.maxY, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i])) continue;
                    parents.push(n.ids[i]);
                    parentsEntry.pop();
                    parentsEntry.push(i);
                    parentsEntry.push(-1);
                    continue block0;
                }
            } else {
                for (i = 0; i < n.entryCount; ++i) {
                    if (!Area.contains(r.minX, r.minY, r.maxX, r.maxY, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i]) || v.processArea(n.ids[i])) continue;
                    return;
                }
            }
            parents.pop();
            parentsEntry.pop();
        }
    }

    private void createNearestNDistanceQueue(Spot p, int count, PriorityQueue distanceQueue, float furthestDistance) {
        if (count <= 0) {
            return;
        }
        IntArray parents = new IntArray();
        parents.push(this.getRoodNodeId());
        IntArray parentsEntry = new IntArray();
        parentsEntry.push(-1);
        IntArray savedValues = new IntArray();
        float savedPriority = 0.0f;
        float furthestDistanceSq = furthestDistance * furthestDistance;
        block0: while (parents.size() > 0) {
            int i;
            Node n = this.getNode(parents.peek());
            int startIndex = parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                for (i = startIndex; i < n.entryCount; ++i) {
                    if (!(Area.distanceSq(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], p.x, p.y) <= furthestDistanceSq)) continue;
                    parents.push(n.ids[i]);
                    parentsEntry.pop();
                    parentsEntry.push(i);
                    parentsEntry.push(-1);
                    continue block0;
                }
            } else {
                for (i = 0; i < n.entryCount; ++i) {
                    float entryDistanceSq = Area.distanceSq(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], p.x, p.y);
                    int entryId = n.ids[i];
                    if (!(entryDistanceSq <= furthestDistanceSq)) continue;
                    distanceQueue.insert(entryId, entryDistanceSq);
                    while (distanceQueue.size() > count) {
                        int value = distanceQueue.getValue();
                        float distanceSq = distanceQueue.getPriority();
                        distanceQueue.pop();
                        if (distanceSq == distanceQueue.getPriority()) {
                            savedValues.add(value);
                            savedPriority = distanceSq;
                            continue;
                        }
                        savedValues.reset();
                    }
                    if (savedValues.size() > 0 && savedPriority == distanceQueue.getPriority()) {
                        for (int svi = 0; svi < savedValues.size(); ++svi) {
                            distanceQueue.insert(savedValues.get(svi), savedPriority);
                        }
                        savedValues.reset();
                    }
                    if (!(distanceQueue.getPriority() < furthestDistanceSq) || distanceQueue.size() < count) continue;
                    furthestDistanceSq = distanceQueue.getPriority();
                }
            }
            parents.pop();
            parentsEntry.pop();
        }
    }

    private float nearest(Spot p, Node n, float furthestDistanceSq, IntArray nearestIds) {
        for (int i = 0; i < n.entryCount; ++i) {
            float tempDistanceSq = Area.distanceSq(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], p.x, p.y);
            if (n.isLeaf()) {
                if (tempDistanceSq < furthestDistanceSq) {
                    furthestDistanceSq = tempDistanceSq;
                    nearestIds.reset();
                }
                if (!(tempDistanceSq <= furthestDistanceSq)) continue;
                nearestIds.add(n.ids[i]);
                continue;
            }
            if (!(tempDistanceSq <= furthestDistanceSq)) continue;
            furthestDistanceSq = this.nearest(p, this.getNode(n.ids[i]), furthestDistanceSq, nearestIds);
        }
        return furthestDistanceSq;
    }

    private boolean intersects(Area r, AreaCallback v, Node n) {
        for (int i = 0; i < n.entryCount; ++i) {
            Node childNode;
            if (!Area.intersects(r.minX, r.minY, r.maxX, r.maxY, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i]) || !(n.isLeaf() ? !v.processArea(n.ids[i]) : !this.intersects(r, v, childNode = this.getNode(n.ids[i])))) continue;
            return false;
        }
        return true;
    }
}

