/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.impl;

import java.util.Arrays;
import org.fit.layout.impl.DefaultArea;
import org.fit.layout.impl.GenericTreeNode;
import org.fit.layout.impl.GridPoint;
import org.fit.layout.model.Rectangular;

public class AreaGrid {
    public static final int GRID_THRESHOLD = 0;
    private int width;
    private int minindent;
    private int maxindent;
    private int[] cols;
    private int height;
    private int[] rows;
    private DefaultArea parent;

    public AreaGrid(DefaultArea area) {
        this.parent = area;
        this.calculateColumns();
        this.calculateRows();
    }

    public int[] getCols() {
        return this.cols;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getRows() {
        return this.rows;
    }

    public int getWidth() {
        return this.width;
    }

    public int getMinIndent() {
        return this.minindent;
    }

    public int getMaxIndent() {
        return this.maxindent;
    }

    public String toString() {
        return "Grid " + this.width + "x" + this.height;
    }

    public DefaultArea getAreaAt(int x, int y) {
        if (x < this.width && y < this.height) {
            for (GenericTreeNode area : this.parent.getChildren()) {
                DefaultArea node = (DefaultArea)area;
                if (x < node.getGridX() || x >= node.getGridX() + node.getGridWidth() || y < node.getGridY() || y >= node.getGridY() + node.getGridHeight()) continue;
                return node;
            }
            return null;
        }
        return null;
    }

    public boolean cellEmpty(int x, int y) {
        return this.getAreaAt(x, y) == null;
    }

    public int getColOfs(int col) throws ArrayIndexOutOfBoundsException {
        if (col < this.width) {
            int ofs = 0;
            for (int i = 0; i < col; ++i) {
                ofs += this.cols[i];
            }
            return ofs;
        }
        if (col == this.width) {
            return this.parent.getWidth();
        }
        throw new ArrayIndexOutOfBoundsException(col + ">" + this.width + " (" + this.parent + ")");
    }

    public int getRowOfs(int row) throws ArrayIndexOutOfBoundsException {
        if (row < this.height) {
            int ofs = 0;
            for (int i = 0; i < row; ++i) {
                ofs += this.rows[i];
            }
            return ofs;
        }
        if (row == this.height) {
            return this.parent.getHeight();
        }
        throw new ArrayIndexOutOfBoundsException(row + ">" + this.height + " (" + this.parent + ")");
    }

    public Rectangular getCellBoundsRelative(int x, int y) {
        int x1 = this.getColOfs(x);
        int y1 = this.getRowOfs(y);
        int x2 = x == this.width - 1 ? this.parent.getWidth() - 1 : x1 + this.cols[x] - 1;
        int y2 = y == this.height - 1 ? this.parent.getHeight() - 1 : y1 + this.rows[y] - 1;
        return new Rectangular(x1, y1, x2, y2);
    }

    public Rectangular getCellBoundsAbsolute(int x, int y) {
        int x1 = this.parent.getX1() + this.getColOfs(x);
        int y1 = this.parent.getY1() + this.getRowOfs(y);
        int x2 = x == this.width - 1 ? this.parent.getX1() + this.parent.getWidth() - 1 : x1 + this.cols[x] - 1;
        int y2 = y == this.height - 1 ? this.parent.getY1() + this.parent.getHeight() - 1 : y1 + this.rows[y] - 1;
        return new Rectangular(x1, y1, x2, y2);
    }

    public Rectangular getAreaBoundsAbsolute(Rectangular area) {
        int x1 = this.parent.getX1() + this.getColOfs(area.getX1());
        int y1 = this.parent.getY1() + this.getRowOfs(area.getY1());
        Rectangular end = this.getCellBoundsAbsolute(area.getX2(), area.getY2());
        return new Rectangular(x1, y1, end.getX2(), end.getY2());
    }

    public int findCellX(int x) {
        int ofs = this.parent.getX1();
        for (int i = 0; i < this.cols.length; ++i) {
            if (x >= (ofs += this.cols[i])) continue;
            return i;
        }
        return -1;
    }

    public int findCellY(int y) {
        int ofs = 0;
        for (int i = 0; i < this.rows.length; ++i) {
            if (y >= (ofs += this.rows[i]) + this.parent.getY1()) continue;
            return i;
        }
        return -1;
    }

    private boolean theSame(int val1, int val2) {
        return Math.abs(val2 - val1) <= 0;
    }

    private void calculateColumns() {
        int i;
        Object[] points = new GridPoint[this.parent.getChildCount() * 2];
        int pi = 0;
        for (GenericTreeNode node : this.parent.getChildren()) {
            DefaultArea area = (DefaultArea)node;
            points[pi] = new GridPoint(area.getX1(), area, true);
            points[pi + 1] = new GridPoint(area.getX2() + 1, area, false);
            pi += 2;
        }
        Arrays.sort(points);
        int cnt = 0;
        int last = this.parent.getX1();
        for (i = 0; i < points.length; ++i) {
            if (this.theSame(((GridPoint)points[i]).value, last)) continue;
            last = ((GridPoint)points[i]).value;
            ++cnt;
        }
        if (!this.theSame(last, this.parent.getX2())) {
            ++cnt;
        }
        this.width = cnt;
        this.maxindent = 0;
        this.minindent = -1;
        this.cols = new int[this.width];
        cnt = 0;
        last = this.parent.getX1();
        for (i = 0; i < points.length; ++i) {
            if (!this.theSame(((GridPoint)points[i]).value, last)) {
                this.cols[cnt] = ((GridPoint)points[i]).value - last;
                last = ((GridPoint)points[i]).value;
                ++cnt;
            }
            if (((GridPoint)points[i]).begin) {
                ((GridPoint)points[i]).area.getGridPosition().setX1(cnt);
                this.maxindent = cnt;
                if (this.minindent != -1) continue;
                this.minindent = this.maxindent;
                continue;
            }
            Rectangular pos = ((GridPoint)points[i]).area.getGridPosition();
            pos.setX2(cnt - 1);
            if (pos.getX2() >= pos.getX1()) continue;
            pos.setX2(pos.getX1());
        }
        if (!this.theSame(last, this.parent.getX2())) {
            this.cols[cnt] = this.parent.getX2() - last;
        }
        if (this.minindent == -1) {
            this.minindent = 0;
        }
    }

    private void calculateRows() {
        int i;
        Object[] points = new GridPoint[this.parent.getChildCount() * 2];
        int pi = 0;
        for (GenericTreeNode node : this.parent.getChildren()) {
            DefaultArea area = (DefaultArea)node;
            points[pi] = new GridPoint(area.getY1(), area, true);
            points[pi + 1] = new GridPoint(area.getY2() + 1, area, false);
            pi += 2;
        }
        Arrays.sort(points);
        int cnt = 0;
        int last = this.parent.getY1();
        for (i = 0; i < points.length; ++i) {
            if (this.theSame(((GridPoint)points[i]).value, last)) continue;
            last = ((GridPoint)points[i]).value;
            ++cnt;
        }
        if (!this.theSame(last, this.parent.getY2())) {
            ++cnt;
        }
        this.height = cnt;
        this.rows = new int[this.height];
        cnt = 0;
        last = this.parent.getY1();
        for (i = 0; i < points.length; ++i) {
            if (!this.theSame(((GridPoint)points[i]).value, last)) {
                this.rows[cnt] = ((GridPoint)points[i]).value - last;
                last = ((GridPoint)points[i]).value;
                ++cnt;
            }
            if (((GridPoint)points[i]).begin) {
                ((GridPoint)points[i]).area.getGridPosition().setY1(cnt);
                continue;
            }
            Rectangular pos = ((GridPoint)points[i]).area.getGridPosition();
            pos.setY2(cnt - 1);
            if (pos.getY2() >= pos.getY1()) continue;
            pos.setY2(pos.getY1());
        }
        if (!this.theSame(last, this.parent.getY2())) {
            this.rows[cnt] = this.parent.getY2() - last;
        }
    }
}

