/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.impl;

import java.awt.Color;
import org.fit.layout.impl.GenericTreeNode;
import org.fit.layout.model.ContentRect;
import org.fit.layout.model.Page;
import org.fit.layout.model.Rectangular;

public class DefaultContentRect
extends GenericTreeNode
implements ContentRect {
    private static int nextid = 1;
    private int id = nextid++;
    private Page page;
    private Rectangular bounds;
    private Color backgroundColor;
    private float underline;
    private float lineThrough;
    private float fontSize;
    private float fontStyle;
    private float fontWeight;
    private int topBorder;
    private int bottomBorder;
    private int leftBorder;
    private int rightBorder;
    private boolean backgroundSeparated;

    public DefaultContentRect() {
    }

    public DefaultContentRect(DefaultContentRect src) {
        this.page = src.page;
        this.bounds = new Rectangular(src.bounds);
        this.backgroundColor = src.backgroundColor == null ? null : new Color(src.backgroundColor.getRed(), src.backgroundColor.getGreen(), src.backgroundColor.getBlue());
        this.underline = src.underline;
        this.lineThrough = src.lineThrough;
        this.fontSize = src.fontSize;
        this.fontWeight = src.fontWeight;
        this.topBorder = src.topBorder;
        this.bottomBorder = src.bottomBorder;
        this.leftBorder = src.leftBorder;
        this.rightBorder = src.rightBorder;
        this.backgroundSeparated = src.backgroundSeparated;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public boolean isBackgroundSeparated() {
        return this.backgroundSeparated;
    }

    public void setBackgroundSeparated(boolean backgroundSeparated) {
        this.backgroundSeparated = backgroundSeparated;
    }

    @Override
    public float getUnderline() {
        return this.underline;
    }

    public void setUnderline(float underline) {
        this.underline = underline;
    }

    @Override
    public float getLineThrough() {
        return this.lineThrough;
    }

    public void setLineThrough(float lineThrough) {
        this.lineThrough = lineThrough;
    }

    @Override
    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    @Override
    public float getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(float fontStyle) {
        this.fontStyle = fontStyle;
    }

    @Override
    public float getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(float fontWeight) {
        this.fontWeight = fontWeight;
    }

    @Override
    public int getTopBorder() {
        return this.topBorder;
    }

    public void setTopBorder(int topBorder) {
        this.topBorder = topBorder;
    }

    @Override
    public int getBottomBorder() {
        return this.bottomBorder;
    }

    public void setBottomBorder(int bottomBorder) {
        this.bottomBorder = bottomBorder;
    }

    @Override
    public int getLeftBorder() {
        return this.leftBorder;
    }

    public void setLeftBorder(int leftBorder) {
        this.leftBorder = leftBorder;
    }

    @Override
    public int getRightBorder() {
        return this.rightBorder;
    }

    public void setRightBorder(int rightBorder) {
        this.rightBorder = rightBorder;
    }

    public void setBorders(int top, int right, int bottom, int left) {
        this.setTopBorder(top);
        this.setRightBorder(right);
        this.setBottomBorder(bottom);
        this.setLeftBorder(left);
    }

    @Override
    public Rectangular getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangular bounds) {
        this.bounds = bounds;
    }

    @Override
    public int getBorderCount() {
        int bcnt = 0;
        if (this.hasTopBorder()) {
            ++bcnt;
        }
        if (this.hasBottomBorder()) {
            ++bcnt;
        }
        if (this.hasLeftBorder()) {
            ++bcnt;
        }
        if (this.hasRightBorder()) {
            ++bcnt;
        }
        return bcnt;
    }

    @Override
    public boolean hasTopBorder() {
        return this.topBorder > 0;
    }

    @Override
    public boolean hasBottomBorder() {
        return this.bottomBorder > 0;
    }

    @Override
    public boolean hasLeftBorder() {
        return this.leftBorder > 0;
    }

    @Override
    public boolean hasRightBorder() {
        return this.rightBorder > 0;
    }

    @Override
    public int getX1() {
        return this.getBounds().getX1();
    }

    @Override
    public int getY1() {
        return this.getBounds().getY1();
    }

    @Override
    public int getX2() {
        return this.getBounds().getX2();
    }

    @Override
    public int getY2() {
        return this.getBounds().getY2();
    }

    @Override
    public int getWidth() {
        return this.getBounds().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getBounds().getHeight();
    }
}

