/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.api;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.fit.layout.api.AreaTreeOperator;
import org.fit.layout.api.AreaTreeProvider;
import org.fit.layout.api.BoxTreeProvider;
import org.fit.layout.api.LogicalTreeProvider;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.api.ScriptObject;

public class ServiceManager {
    private static Map<String, BoxTreeProvider> boxProviders;
    private static Map<String, AreaTreeProvider> areaProviders;
    private static Map<String, LogicalTreeProvider> logicalProviders;
    private static Map<String, AreaTreeOperator> operators;
    private static Map<String, ScriptObject> scriptObjects;

    public static Map<String, BoxTreeProvider> findBoxTreeProviders() {
        if (boxProviders == null) {
            ServiceLoader<BoxTreeProvider> loader = ServiceLoader.load(BoxTreeProvider.class);
            Iterator<BoxTreeProvider> it = loader.iterator();
            boxProviders = new HashMap<String, BoxTreeProvider>();
            while (it.hasNext()) {
                BoxTreeProvider op = it.next();
                boxProviders.put(op.getId(), op);
            }
        }
        return boxProviders;
    }

    public static Map<String, AreaTreeProvider> findAreaTreeProviders() {
        if (areaProviders == null) {
            ServiceLoader<AreaTreeProvider> loader = ServiceLoader.load(AreaTreeProvider.class);
            Iterator<AreaTreeProvider> it = loader.iterator();
            areaProviders = new HashMap<String, AreaTreeProvider>();
            while (it.hasNext()) {
                AreaTreeProvider op = it.next();
                areaProviders.put(op.getId(), op);
            }
        }
        return areaProviders;
    }

    public static Map<String, LogicalTreeProvider> findLogicalTreeProviders() {
        if (logicalProviders == null) {
            ServiceLoader<LogicalTreeProvider> loader = ServiceLoader.load(LogicalTreeProvider.class);
            Iterator<LogicalTreeProvider> it = loader.iterator();
            logicalProviders = new HashMap<String, LogicalTreeProvider>();
            while (it.hasNext()) {
                LogicalTreeProvider op = it.next();
                logicalProviders.put(op.getId(), op);
            }
        }
        return logicalProviders;
    }

    public static Map<String, AreaTreeOperator> findAreaTreeOperators() {
        if (operators == null) {
            ServiceLoader<AreaTreeOperator> loader = ServiceLoader.load(AreaTreeOperator.class);
            Iterator<AreaTreeOperator> it = loader.iterator();
            operators = new HashMap<String, AreaTreeOperator>();
            while (it.hasNext()) {
                AreaTreeOperator op = it.next();
                operators.put(op.getId(), op);
            }
        }
        return operators;
    }

    public static Map<String, ScriptObject> findScriptObjects() {
        if (scriptObjects == null) {
            ServiceLoader<ScriptObject> loader = ServiceLoader.load(ScriptObject.class);
            Iterator<ScriptObject> it = loader.iterator();
            scriptObjects = new HashMap<String, ScriptObject>();
            while (it.hasNext()) {
                ScriptObject op = it.next();
                scriptObjects.put(op.getName(), op);
            }
        }
        return scriptObjects;
    }

    public static void setServiceParams(ParametrizedOperation op, Map<String, Object> params) {
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                op.setParam(entry.getKey(), entry.getValue());
            }
        }
    }
}

