/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.impl;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.fit.layout.impl.AreaGrid;
import org.fit.layout.impl.DefaultContentRect;
import org.fit.layout.impl.DefaultGridTopology;
import org.fit.layout.impl.GenericTreeNode;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTopology;
import org.fit.layout.model.Box;
import org.fit.layout.model.Rectangular;
import org.fit.layout.model.Tag;

public class DefaultArea
extends DefaultContentRect
implements Area {
    private String name;
    private AreaTopology topology;
    private Vector<Box> boxes;
    private Map<Tag, Float> tags;
    private Rectangular contentBounds;
    private AreaGrid grid;
    private Rectangular gp;
    private Area previousOnLine = null;
    private Area nextOnLine = null;

    public DefaultArea(Rectangular r) {
        this.name = null;
        this.boxes = new Vector();
        this.tags = new HashMap<Tag, Float>();
        this.setBounds(new Rectangular(r));
        this.setBackgroundColor(null);
        this.grid = null;
        this.gp = new Rectangular();
    }

    public DefaultArea(DefaultArea src) {
        super(src);
        this.name = src.name == null ? null : new String(src.name);
        this.boxes = new Vector<Box>(src.getBoxes());
        this.tags = new HashMap<Tag, Float>();
        this.contentBounds = src.contentBounds == null ? null : new Rectangular(src.contentBounds);
        this.grid = null;
        this.gp = new Rectangular();
    }

    public DefaultArea(int x1, int y1, int x2, int y2) {
        this(new Rectangular(x1, y1, x2, y2));
    }

    public DefaultArea(Box box) {
        this(box.getBounds());
        this.addBox(box);
        this.setBounds(new Rectangular(this.contentBounds));
        this.setName(box.toString());
        this.setBackgroundColor(box.getBackgroundColor());
        this.setBackgroundSeparated(box.isBackgroundSeparated());
        this.setBorders(box.getTopBorder(), box.getRightBorder(), box.getBottomBorder(), box.getLeftBorder());
    }

    public DefaultArea(List<Box> boxList) {
        this(boxList.get(0));
        for (Box box : boxList) {
            this.addBox(box);
        }
        this.setBounds(new Rectangular(this.contentBounds));
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Rectangular getContentBounds() {
        return this.contentBounds;
    }

    @Override
    public AreaTopology getTopology() {
        if (this.topology == null) {
            this.topology = this.createTopology();
        }
        return this.topology;
    }

    protected AreaTopology createTopology() {
        return new DefaultGridTopology(this);
    }

    @Override
    public Color getEffectiveBackgroundColor() {
        if (this.getBackgroundColor() != null) {
            return this.getBackgroundColor();
        }
        if (this.getParentArea() != null) {
            return this.getParentArea().getEffectiveBackgroundColor();
        }
        return Color.WHITE;
    }

    @Override
    public Area getParentArea() {
        return (Area)((Object)this.getParent());
    }

    @Override
    public Area getPreviousSibling() {
        return (Area)((Object)this.getPreviousSiblingNode());
    }

    @Override
    public Area getNextSibling() {
        return (Area)((Object)this.getNextSiblingNode());
    }

    @Override
    public Area getChildArea(int index) throws ArrayIndexOutOfBoundsException {
        return (Area)((Object)this.getChildAt(index));
    }

    @Override
    public List<Area> getChildAreas() {
        Vector<Area> ret = new Vector<Area>(this.getChildCount());
        for (GenericTreeNode child : this.getChildren()) {
            ret.add((Area)((Object)child));
        }
        return ret;
    }

    @Override
    public int getIndex(Area child) {
        return super.getIndex((DefaultArea)child);
    }

    @Override
    public void appendChild(Area child) {
        this.add((DefaultArea)child);
        this.getBounds().expandToEnclose(child.getBounds());
    }

    @Override
    public void insertChild(Area child, int index) {
        this.insert((DefaultArea)child, index);
    }

    @Override
    public void removeChild(Area child) {
        this.remove((DefaultArea)child);
    }

    public Area getPreviousOnLine() {
        return this.previousOnLine;
    }

    public void setPreviousOnLine(Area previousOnLine) {
        this.previousOnLine = previousOnLine;
    }

    public Area getNextOnLine() {
        return this.nextOnLine;
    }

    public void setNextOnLine(Area nextOnLine) {
        this.nextOnLine = nextOnLine;
    }

    @Override
    public String getText() {
        String ret = "";
        if (this.isLeaf()) {
            ret = this.getBoxText();
        } else {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ret = ret + this.getChildArea(i).getText();
            }
        }
        return ret;
    }

    @Override
    public String getText(String separator) {
        String ret = "";
        if (this.isLeaf()) {
            ret = this.getBoxText();
        } else {
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (this.getChildArea(i).isLeaf() && !ret.isEmpty()) {
                    ret = ret + separator;
                }
                ret = ret + this.getChildArea(i).getText(separator);
            }
        }
        return ret;
    }

    @Override
    public boolean isReplaced() {
        boolean empty = true;
        for (Box root : this.boxes) {
            empty = false;
            if (root.getType() == Box.Type.REPLACED_CONTENT) continue;
            return false;
        }
        return !empty;
    }

    protected void addBox(Box box) {
        this.boxes.add(box);
        Rectangular sb = box.getVisualBounds();
        if (this.contentBounds == null) {
            this.contentBounds = new Rectangular(sb);
        } else if (sb.getWidth() > 0 && sb.getHeight() > 0) {
            this.contentBounds.expandToEnclose(sb);
        }
    }

    @Override
    public Vector<Box> getBoxes() {
        return this.boxes;
    }

    @Override
    public Vector<Box> getAllBoxes() {
        Vector<Box> ret = new Vector<Box>();
        this.recursiveFindBoxes(this, ret);
        return ret;
    }

    private void recursiveFindBoxes(Area root, Vector<Box> result) {
        result.addAll(root.getBoxes());
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveFindBoxes((Area)root.getChildArea(i), result);
        }
    }

    public String getBoxText() {
        StringBuilder ret = new StringBuilder();
        boolean start = true;
        Iterator<Box> it = this.boxes.iterator();
        while (it.hasNext()) {
            if (!start) {
                ret.append(' ');
            } else {
                start = false;
            }
            ret.append(it.next().getText());
        }
        return ret.toString();
    }

    public void createGrid() {
        this.grid = new AreaGrid(this);
    }

    public AreaGrid getGrid() {
        return this.grid;
    }

    public int getGridHeight() {
        return this.gp.getHeight();
    }

    public int getGridWidth() {
        return this.gp.getWidth();
    }

    public int getGridX() {
        return this.gp.getX1();
    }

    public void setGridX(int gridX) {
        this.gp.setX1(gridX);
    }

    public int getGridY() {
        return this.gp.getY1();
    }

    public void setGridY(int gridY) {
        this.gp.setY1(gridY);
    }

    public Rectangular getGridPosition() {
        return this.gp;
    }

    public void setGridPosition(Rectangular pos) {
        this.gp = new Rectangular(pos);
    }

    public DefaultArea getChildAtGridPos(int x, int y) {
        for (GenericTreeNode child : this.getChildren()) {
            DefaultArea childarea = (DefaultArea)child;
            if (!childarea.getGridPosition().contains(x, y)) continue;
            return childarea;
        }
        return null;
    }

    @Override
    public void addTag(Tag tag, float support) {
        Float oldsupport = this.tags.get(tag);
        if (oldsupport == null || oldsupport.floatValue() < support) {
            this.tags.put(tag, Float.valueOf(support));
        }
    }

    @Override
    public boolean hasTag(Tag tag) {
        return this.tags.get(tag) != null;
    }

    @Override
    public boolean hasTag(Tag tag, float minSupport) {
        Float sp = this.tags.get(tag);
        return sp != null && sp.floatValue() >= minSupport;
    }

    @Override
    public float getTagSupport(Tag tag) {
        Float f = this.tags.get(tag);
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    @Override
    public Tag getMostSupportedTag() {
        float max = -1.0f;
        Tag ret = null;
        for (Map.Entry<Tag, Float> entry : this.tags.entrySet()) {
            if (!(entry.getValue().floatValue() > max)) continue;
            max = entry.getValue().floatValue();
            ret = entry.getKey();
        }
        return ret;
    }

    public void removeAllTags(Collection<Tag> c) {
        for (Tag t : c) {
            this.tags.remove(t);
        }
    }

    @Override
    public void removeTag(Tag tag) {
        this.tags.remove(tag);
    }

    public boolean containsTag(Tag tag) {
        if (this.hasTag(tag)) {
            return true;
        }
        for (GenericTreeNode child : this.getChildren()) {
            if (!((Area)((Object)child)).hasTag(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<Tag, Float> getTags() {
        return this.tags;
    }

    public String toString() {
        String bs = "";
        if (this.hasTopBorder()) {
            bs = bs + "^";
        }
        if (this.hasLeftBorder()) {
            bs = bs + "<";
        }
        if (this.hasRightBorder()) {
            bs = bs + ">";
        }
        if (this.hasBottomBorder()) {
            bs = bs + "_";
        }
        if (this.isBackgroundSeparated()) {
            bs = bs + "*";
        }
        if (this.name != null) {
            return bs + " " + this.name + " " + this.getBounds().toString();
        }
        return bs + " " + "<area> " + this.getBounds().toString();
    }
}

