/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.impl;

import java.util.List;
import java.util.Vector;
import org.fit.layout.impl.GenericTreeNode;
import org.fit.layout.model.Area;
import org.fit.layout.model.LogicalArea;
import org.fit.layout.model.Tag;

public class DefaultLogicalArea
extends GenericTreeNode
implements LogicalArea {
    private List<Area> areas = new Vector<Area>();
    private String text;
    private Tag mainTag;

    public DefaultLogicalArea() {
        this.text = "";
    }

    public DefaultLogicalArea(Area src) {
        this.areas.add(src);
        this.text = src.getText();
    }

    public DefaultLogicalArea(Area src, String text) {
        this.areas.add(src);
        this.text = text;
    }

    @Override
    public void addArea(Area a) {
        this.areas.add(a);
    }

    @Override
    public List<Area> getAreas() {
        return this.areas;
    }

    @Override
    public int getAreaCount() {
        return this.areas.size();
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setMainTag(Tag mainTag) {
        this.mainTag = mainTag;
    }

    @Override
    public Tag getMainTag() {
        return this.mainTag;
    }

    public String toString() {
        String tagstr = this.mainTag == null ? "---" : this.mainTag.getValue();
        return "(" + tagstr + ") " + this.getText();
    }

    @Override
    public LogicalArea getParentArea() {
        return (LogicalArea)((Object)this.getParent());
    }

    @Override
    public LogicalArea getPreviousSibling() {
        return (LogicalArea)((Object)this.getPreviousSiblingNode());
    }

    @Override
    public LogicalArea getNextSibling() {
        return (LogicalArea)((Object)this.getNextSiblingNode());
    }

    @Override
    public LogicalArea getChildArea(int index) throws ArrayIndexOutOfBoundsException {
        return (LogicalArea)((Object)this.getChildAt(index));
    }

    @Override
    public List<LogicalArea> getChildAreas() {
        Vector<LogicalArea> ret = new Vector<LogicalArea>(this.getChildCount());
        for (GenericTreeNode child : this.getChildren()) {
            ret.add((LogicalArea)((Object)child));
        }
        return ret;
    }

    @Override
    public void appendChild(LogicalArea child) {
        this.add((DefaultLogicalArea)child);
    }

    @Override
    public void insertChild(LogicalArea child, int index) {
        this.insert((DefaultLogicalArea)child, index);
    }

    @Override
    public void removeChild(LogicalArea child) {
        this.remove((DefaultLogicalArea)child);
    }

    @Override
    public int getIndex(LogicalArea child) {
        return super.getIndex((DefaultLogicalArea)child);
    }
}

