/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.impl;

import java.net.URL;
import java.util.Vector;
import org.fit.layout.model.Box;
import org.fit.layout.model.Page;
import org.fit.layout.model.Rectangular;

public class DefaultPage
implements Page {
    protected URL url;
    protected Box root;
    protected int width;
    protected int height;

    public DefaultPage(URL url) {
        this.url = url;
    }

    @Override
    public URL getSourceURL() {
        return this.url;
    }

    @Override
    public Box getRoot() {
        return this.root;
    }

    public void setRoot(Box root) {
        this.root = root;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public Box getBoxAt(int x, int y) {
        return this.recursiveGetBoxAt(this.root, x, y);
    }

    protected Box recursiveGetBoxAt(Box root, int x, int y) {
        if (root.getBounds().contains(x, y)) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                Box ret = this.recursiveGetBoxAt(root.getChildBox(i), x, y);
                if (ret == null) continue;
                return ret;
            }
            return root;
        }
        return null;
    }

    @Override
    public Vector<Box> getBoxesInRegion(Rectangular r) {
        Vector<Box> ret = new Vector<Box>();
        this.recursiveGetBoxesInRegion(this.root, r, ret);
        return ret;
    }

    private void recursiveGetBoxesInRegion(Box root, Rectangular r, Vector<Box> result) {
        if (r.intersects(root.getBounds())) {
            result.add(root);
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.recursiveGetBoxesInRegion(root.getChildBox(i), r, result);
            }
        }
    }
}

