/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.model;

import java.awt.Rectangle;

public class Rectangular {
    protected int x1;
    protected int y1;
    protected int x2;
    protected int y2;

    public Rectangular() {
        this.x1 = 0;
        this.y1 = 0;
        this.x2 = -1;
        this.y2 = -1;
    }

    public Rectangular(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
    }

    public Rectangular(Rectangular src) {
        this.x1 = src.x1;
        this.x2 = src.x2;
        this.y1 = src.y1;
        this.y2 = src.y2;
    }

    public Rectangular(Rectangle src) {
        this.x1 = src.x;
        this.x2 = src.x + src.width - 1;
        this.y1 = src.y;
        this.y2 = src.y + src.height - 1;
    }

    public void copy(Rectangular src) {
        this.x1 = src.x1;
        this.x2 = src.x2;
        this.y1 = src.y1;
        this.y2 = src.y2;
    }

    public int getX1() {
        return this.x1;
    }

    public void setX1(int x1) {
        this.x1 = x1;
    }

    public int getX2() {
        return this.x2;
    }

    public void setX2(int x2) {
        this.x2 = x2;
    }

    public int getY1() {
        return this.y1;
    }

    public void setY1(int y1) {
        this.y1 = y1;
    }

    public int getY2() {
        return this.y2;
    }

    public void setY2(int y2) {
        this.y2 = y2;
    }

    public int getWidth() {
        return this.x2 - this.x1 + 1;
    }

    public int getHeight() {
        return this.y2 - this.y1 + 1;
    }

    public int midX() {
        return (this.x2 + this.x1) / 2;
    }

    public int midY() {
        return (this.y2 + this.y1) / 2;
    }

    public int getArea() {
        int a = this.getWidth() * this.getHeight();
        return a >= 0 ? a : 0;
    }

    public boolean isEmpty() {
        return this.x2 < this.x1 || this.y2 < this.y1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rectangular) {
            Rectangular r = (Rectangular)obj;
            return r.x1 == this.x1 && r.y1 == this.y1 && r.x2 == this.x2 && r.y2 == this.y2;
        }
        return false;
    }

    public boolean encloses(Rectangular other) {
        return this.x1 <= other.x1 && this.y1 <= other.y1 && this.x2 >= other.x2 && this.y2 >= other.y2;
    }

    public boolean enclosesX(Rectangular other) {
        return this.x1 <= other.x1 && this.x2 >= other.x2;
    }

    public boolean enclosesY(Rectangular other) {
        return this.y1 <= other.y1 && this.y2 >= other.y2;
    }

    public boolean contains(int x, int y) {
        return this.x1 <= x && this.y1 <= y && this.x2 >= x && this.y2 >= y;
    }

    public boolean intersects(Rectangular other) {
        return other.x1 <= this.x2 && other.x2 >= this.x1 && other.y1 <= this.y2 && other.y2 >= this.y1;
    }

    public Rectangular intersection(Rectangular other) {
        if (this.intersects(other)) {
            return new Rectangular(Math.max(this.x1, other.x1), Math.max(this.y1, other.y1), Math.min(this.x2, other.x2), Math.min(this.y2, other.y2));
        }
        return new Rectangular();
    }

    public Rectangular replaceX(Rectangular other) {
        Rectangular ret = new Rectangular(this);
        ret.x1 = other.x1;
        ret.x2 = other.x2;
        return ret;
    }

    public Rectangular replaceY(Rectangular other) {
        Rectangular ret = new Rectangular(this);
        ret.y1 = other.y1;
        ret.y2 = other.y2;
        return ret;
    }

    public Rectangular hsplit(Rectangular other) {
        if (this.intersects(other)) {
            Rectangular a = new Rectangular(this);
            Rectangular b = new Rectangular(this);
            if (a.x2 > other.x1 - 1) {
                a.x2 = other.x1 - 1;
            }
            if (b.x1 < other.x2 + 1) {
                b.x1 = other.x2 + 1;
            }
            if (a.isEmpty()) {
                this.x1 = b.x1;
                return null;
            }
            this.x2 = a.x2;
            if (b.isEmpty()) {
                return null;
            }
            return b;
        }
        return null;
    }

    public Rectangular vsplit(Rectangular other) {
        if (this.intersects(other)) {
            Rectangular a = new Rectangular(this);
            Rectangular b = new Rectangular(this);
            if (a.y2 > other.y1 - 1) {
                a.y2 = other.y1 - 1;
            }
            if (b.y1 < other.y2 + 1) {
                b.y1 = other.y2 + 1;
            }
            if (a.isEmpty()) {
                this.y1 = b.y1;
                return null;
            }
            this.y2 = a.y2;
            if (b.isEmpty()) {
                return null;
            }
            return b;
        }
        return null;
    }

    public void expandToEnclose(Rectangular other) {
        if (other.x1 < this.x1) {
            this.x1 = other.x1;
        }
        if (other.y1 < this.y1) {
            this.y1 = other.y1;
        }
        if (other.x2 > this.x2) {
            this.x2 = other.x2;
        }
        if (other.y2 > this.y2) {
            this.y2 = other.y2;
        }
    }

    public String toString() {
        return "[" + this.x1 + ", " + this.y1 + ", " + this.x2 + ", " + this.y2 + "]";
    }
}

