/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.fit.layout.api.AreaTreeOperator;
import org.fit.layout.api.AreaTreeProvider;
import org.fit.layout.api.BoxTreeProvider;
import org.fit.layout.api.LogicalTreeProvider;
import org.fit.layout.api.PageStorage;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.api.ScriptObject;
import org.fit.layout.api.Service;
import org.fit.layout.gui.BrowserPlugin;

public class ServiceManager {
    private static List<BrowserPlugin> browserPlugins;
    private static Map<String, BoxTreeProvider> boxProviders;
    private static Map<String, AreaTreeProvider> areaProviders;
    private static Map<String, LogicalTreeProvider> logicalProviders;
    private static Map<String, AreaTreeOperator> operators;
    private static Map<String, PageStorage> pageStorages;
    private static Map<String, ParametrizedOperation> parametrizedServices;
    private static Map<String, ScriptObject> scriptObjects;

    public static List<BrowserPlugin> findBrowserPlugins() {
        return browserPlugins;
    }

    public static Map<String, BoxTreeProvider> findBoxTreeProviders() {
        return boxProviders;
    }

    public static Map<String, AreaTreeProvider> findAreaTreeProviders() {
        return areaProviders;
    }

    public static Map<String, LogicalTreeProvider> findLogicalTreeProviders() {
        return logicalProviders;
    }

    public static Map<String, AreaTreeOperator> findAreaTreeOperators() {
        return operators;
    }

    public static Map<String, ScriptObject> findScriptObjects() {
        return scriptObjects;
    }

    public static Map<String, PageStorage> findPageStorages() {
        return pageStorages;
    }

    public static <T extends Service> Map<String, T> loadServicesByType(Class<T> clazz) {
        ServiceLoader<T> loader = ServiceLoader.load(clazz);
        Iterator<T> it = loader.iterator();
        HashMap<String, Service> ret = new HashMap<String, Service>();
        while (it.hasNext()) {
            Service op = (Service)it.next();
            ret.put(op.getId(), op);
            if (op instanceof ParametrizedOperation) {
                ServiceManager.addParametrizedService(op.getId(), (ParametrizedOperation)((Object)op));
            }
            if (!(op instanceof ScriptObject)) continue;
            ServiceManager.addScriptObject(((ScriptObject)((Object)op)).getVarName(), (ScriptObject)((Object)op));
        }
        return ret;
    }

    private static List<BrowserPlugin> loadBrowserPlugins() {
        ServiceLoader<BrowserPlugin> loader = ServiceLoader.load(BrowserPlugin.class);
        Iterator<BrowserPlugin> it = loader.iterator();
        ArrayList<BrowserPlugin> ret = new ArrayList<BrowserPlugin>();
        while (it.hasNext()) {
            BrowserPlugin plugin = it.next();
            ret.add(plugin);
            if (!(plugin instanceof ScriptObject)) continue;
            ServiceManager.addScriptObject(((ScriptObject)((Object)plugin)).getVarName(), (ScriptObject)((Object)plugin));
        }
        return ret;
    }

    private static Map<String, ScriptObject> loadScriptObjects() {
        ServiceLoader<ScriptObject> loader = ServiceLoader.load(ScriptObject.class);
        for (ScriptObject op : loader) {
            ServiceManager.addScriptObject(op.getVarName(), op);
        }
        return scriptObjects;
    }

    public static void setServiceParams(ParametrizedOperation op, Map<String, Object> params) {
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                op.setParam(entry.getKey(), entry.getValue());
            }
        }
    }

    public static Map<String, Object> getServiceParams(ParametrizedOperation op) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String name : op.getParamNames()) {
            ret.put(name, op.getParam(name));
        }
        return ret;
    }

    public static ParametrizedOperation findParmetrizedService(String id) {
        if (parametrizedServices == null) {
            return null;
        }
        return parametrizedServices.get(id);
    }

    private static void addParametrizedService(String id, ParametrizedOperation op) {
        parametrizedServices.put(id, op);
    }

    private static void addScriptObject(String id, ScriptObject op) {
        if (!scriptObjects.containsKey(id)) {
            scriptObjects.put(id, op);
        }
    }

    static {
        scriptObjects = new HashMap<String, ScriptObject>();
        parametrizedServices = new HashMap<String, ParametrizedOperation>();
        browserPlugins = ServiceManager.loadBrowserPlugins();
        boxProviders = ServiceManager.loadServicesByType(BoxTreeProvider.class);
        areaProviders = ServiceManager.loadServicesByType(AreaTreeProvider.class);
        logicalProviders = ServiceManager.loadServicesByType(LogicalTreeProvider.class);
        operators = ServiceManager.loadServicesByType(AreaTreeOperator.class);
        pageStorages = ServiceManager.loadServicesByType(PageStorage.class);
        ServiceManager.loadScriptObjects();
    }
}

