/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.impl;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.fit.layout.impl.AreaGrid;
import org.fit.layout.impl.DefaultContentRect;
import org.fit.layout.impl.DefaultGridTopology;
import org.fit.layout.impl.GenericTreeNode;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTopology;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Border;
import org.fit.layout.model.Box;
import org.fit.layout.model.Rectangular;
import org.fit.layout.model.Tag;

public class DefaultArea
extends DefaultContentRect
implements Area {
    private String name;
    private AreaTree areaTree;
    private AreaTopology topology;
    private Vector<Box> boxes;
    private Map<Tag, Float> tags;
    private Rectangular contentBounds;
    private AreaGrid grid;
    private Rectangular gp;
    private Area previousOnLine = null;
    private Area nextOnLine = null;
    private boolean hsep;
    private boolean vsep;

    public DefaultArea(Rectangular r) {
        this.name = null;
        this.boxes = new Vector();
        this.tags = new HashMap<Tag, Float>();
        this.setBounds(new Rectangular(r));
        this.setBackgroundColor(null);
        this.grid = null;
        this.gp = new Rectangular();
        this.hsep = false;
        this.vsep = false;
    }

    public DefaultArea(DefaultArea src) {
        super(src);
        this.name = src.name == null ? null : new String(src.name);
        this.boxes = new Vector<Box>(src.getBoxes());
        this.tags = new HashMap<Tag, Float>();
        this.contentBounds = src.contentBounds == null ? null : new Rectangular(src.contentBounds);
        this.grid = null;
        this.gp = new Rectangular();
        this.vsep = src.vsep;
        this.hsep = src.hsep;
    }

    public DefaultArea(int x1, int y1, int x2, int y2) {
        this(new Rectangular(x1, y1, x2, y2));
    }

    public DefaultArea(Box box) {
        this(box.getBounds());
        this.setPage(box.getPage());
        this.addBox(box);
        this.setBounds(new Rectangular(this.contentBounds));
        this.setName(this.getBoxDescription(box));
        this.setBackgroundColor(box.getBackgroundColor());
        this.setBackgroundSeparated(box.isBackgroundSeparated());
        for (Border.Side side : Border.Side.values()) {
            this.setBorderStyle(side, box.getBorderStyle(side));
        }
    }

    public DefaultArea(List<Box> boxList) {
        this(boxList.get(0));
        for (Box box : boxList) {
            this.addBox(box);
        }
        this.setBounds(new Rectangular(this.contentBounds));
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AreaTree getAreaTree() {
        return this.areaTree;
    }

    public void setAreaTree(AreaTree areaTree) {
        this.areaTree = areaTree;
    }

    public Rectangular getContentBounds() {
        return this.contentBounds;
    }

    @Override
    public void move(int xofs, int yofs) {
        this.getContentBounds().move(xofs, yofs);
        super.move(xofs, yofs);
    }

    @Override
    public AreaTopology getTopology() {
        if (this.topology == null) {
            this.topology = this.createTopology();
        }
        return this.topology;
    }

    @Override
    public void updateTopologies() {
        this.createGrid();
    }

    protected AreaTopology createTopology() {
        return new DefaultGridTopology(this);
    }

    @Override
    public Color getEffectiveBackgroundColor() {
        if (this.getBackgroundColor() != null) {
            return this.getBackgroundColor();
        }
        if (this.getParentArea() != null) {
            return this.getParentArea().getEffectiveBackgroundColor();
        }
        return Color.WHITE;
    }

    @Override
    public Area getParentArea() {
        return (Area)((Object)this.getParent());
    }

    @Override
    public Area getPreviousSibling() {
        return (Area)((Object)this.getPreviousSiblingNode());
    }

    @Override
    public Area getNextSibling() {
        return (Area)((Object)this.getNextSiblingNode());
    }

    @Override
    public Area getChildArea(int index) throws ArrayIndexOutOfBoundsException {
        return (Area)((Object)this.getChildAt(index));
    }

    @Override
    public List<Area> getChildAreas() {
        Vector<Area> ret = new Vector<Area>(this.getChildCount());
        for (GenericTreeNode child : this.getChildren()) {
            ret.add((Area)((Object)child));
        }
        return ret;
    }

    @Override
    public int getIndex(Area child) {
        return super.getIndex((DefaultArea)child);
    }

    @Override
    public void appendChild(Area child) {
        ((DefaultArea)child).setAreaTree(this.areaTree);
        this.add((DefaultArea)child);
        this.getBounds().expandToEnclose(child.getBounds());
    }

    @Override
    public void appendChildren(List<Area> list) {
        for (Area child : list) {
            this.add((DefaultArea)child);
            ((DefaultArea)child).setAreaTree(this.areaTree);
            this.getBounds().expandToEnclose(child.getBounds());
        }
    }

    @Override
    public void insertChild(Area child, int index) {
        ((DefaultArea)child).setAreaTree(this.areaTree);
        this.insert((DefaultArea)child, index);
    }

    @Override
    public void removeChild(Area child) {
        ((DefaultArea)child).setAreaTree(null);
        this.remove((DefaultArea)child);
    }

    public Area getPreviousOnLine() {
        return this.previousOnLine;
    }

    public void setPreviousOnLine(Area previousOnLine) {
        this.previousOnLine = previousOnLine;
    }

    public Area getNextOnLine() {
        return this.nextOnLine;
    }

    public void setNextOnLine(Area nextOnLine) {
        this.nextOnLine = nextOnLine;
    }

    @Override
    public String getText() {
        String ret = "";
        if (this.isLeaf()) {
            ret = this.getBoxText();
        } else {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ret = ret + this.getChildArea(i).getText();
            }
        }
        return ret;
    }

    @Override
    public String getText(String separator) {
        String ret = "";
        if (this.isLeaf()) {
            ret = this.getBoxText();
        } else {
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (this.getChildArea(i).isLeaf() && !ret.isEmpty()) {
                    ret = ret + separator;
                }
                ret = ret + this.getChildArea(i).getText(separator);
            }
        }
        return ret;
    }

    @Override
    public boolean isReplaced() {
        boolean empty = true;
        for (Box root : this.boxes) {
            empty = false;
            if (root.getType() == Box.Type.REPLACED_CONTENT) continue;
            return false;
        }
        return !empty;
    }

    @Override
    public boolean isAncestorOf(Area other) {
        for (Area parent = (Area)other.getParentArea(); parent != null; parent = (Area)parent.getParentArea()) {
            if (parent != this) continue;
            return true;
        }
        return false;
    }

    public void addBox(Box box) {
        this.boxes.add(box);
        Rectangular sb = box.getVisualBounds();
        if (this.contentBounds == null) {
            this.contentBounds = new Rectangular(sb);
        } else if (sb.getWidth() > 0 && sb.getHeight() > 0) {
            this.contentBounds.expandToEnclose(sb);
        }
    }

    @Override
    public Vector<Box> getBoxes() {
        return this.boxes;
    }

    @Override
    public Vector<Box> getAllBoxes() {
        Vector<Box> ret = new Vector<Box>();
        this.recursiveFindBoxes(this, ret);
        return ret;
    }

    private void recursiveFindBoxes(Area root, Vector<Box> result) {
        result.addAll(root.getBoxes());
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveFindBoxes((Area)root.getChildArea(i), result);
        }
    }

    public String getBoxText() {
        StringBuilder ret = new StringBuilder();
        boolean start = true;
        Iterator<Box> it = this.boxes.iterator();
        while (it.hasNext()) {
            if (!start) {
                ret.append(' ');
            } else {
                start = false;
            }
            ret.append(it.next().getText());
        }
        return ret.toString();
    }

    public void removeBox(Box box) {
        this.boxes.remove(box);
    }

    public void removeBoxes(Collection<Box> box) {
        this.boxes.removeAll(box);
    }

    public void createGrid() {
        this.grid = new AreaGrid(this, this.getTopology());
    }

    public AreaGrid getGrid() {
        if (this.grid == null) {
            this.createGrid();
        }
        return this.grid;
    }

    public int getGridHeight() {
        return this.gp.getHeight();
    }

    public int getGridWidth() {
        return this.gp.getWidth();
    }

    public int getGridX() {
        return this.gp.getX1();
    }

    public void setGridX(int gridX) {
        this.gp.setX1(gridX);
    }

    public int getGridY() {
        return this.gp.getY1();
    }

    public void setGridY(int gridY) {
        this.gp.setY1(gridY);
    }

    public Rectangular getGridPosition() {
        return this.gp;
    }

    public void setGridPosition(Rectangular pos) {
        this.gp = new Rectangular(pos);
    }

    public DefaultArea getChildAtGridPos(int x, int y) {
        for (GenericTreeNode child : this.getChildren()) {
            DefaultArea childarea = (DefaultArea)child;
            if (!childarea.getGridPosition().contains(x, y)) continue;
            return childarea;
        }
        return null;
    }

    @Override
    public void addTag(Tag tag, float support) {
        Float oldsupport = this.tags.get(tag);
        if (oldsupport == null || oldsupport.floatValue() < support) {
            this.tags.put(tag, Float.valueOf(support));
        }
    }

    @Override
    public boolean hasTag(Tag tag) {
        return this.tags.get(tag) != null;
    }

    @Override
    public boolean hasTag(Tag tag, float minSupport) {
        Float sp = this.tags.get(tag);
        return sp != null && sp.floatValue() >= minSupport;
    }

    @Override
    public Set<Tag> getSupportedTags(float minSupport) {
        HashSet<Tag> ret = new HashSet<Tag>();
        for (Map.Entry<Tag, Float> entry : this.tags.entrySet()) {
            if (!(entry.getValue().floatValue() >= minSupport)) continue;
            ret.add(entry.getKey());
        }
        return ret;
    }

    @Override
    public float getTagSupport(Tag tag) {
        Float f = this.tags.get(tag);
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    @Override
    public Tag getMostSupportedTag() {
        float max = -1.0f;
        Tag ret = null;
        for (Map.Entry<Tag, Float> entry : this.tags.entrySet()) {
            if (!(entry.getValue().floatValue() > max)) continue;
            max = entry.getValue().floatValue();
            ret = entry.getKey();
        }
        return ret;
    }

    public void removeAllTags(Collection<Tag> c) {
        for (Tag t : c) {
            this.tags.remove(t);
        }
    }

    @Override
    public void removeTag(Tag tag) {
        this.tags.remove(tag);
    }

    public boolean containsTag(Tag tag) {
        if (this.hasTag(tag)) {
            return true;
        }
        for (GenericTreeNode child : this.getChildren()) {
            if (!((Area)((Object)child)).hasTag(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<Tag, Float> getTags() {
        return this.tags;
    }

    public void SetHorizontalSeparator(boolean hsep) {
        this.hsep = hsep;
    }

    @Override
    public boolean isHorizontalSeparator() {
        return this.hsep;
    }

    public void SetVerticalSeparator(boolean vsep) {
        this.hsep = vsep;
    }

    @Override
    public boolean isVerticalSeparator() {
        return this.vsep;
    }

    @Override
    public boolean isSeparator() {
        return this.isHorizontalSeparator() || this.isVerticalSeparator();
    }

    @Override
    public Area createSuperArea(Rectangular gp, List<Area> selected, String name) {
        if (this.getChildCount() > 1 && selected.size() > 1 && selected.size() != this.getChildCount()) {
            DefaultArea area = new DefaultArea(this.getX1() + this.getGrid().getColOfs(gp.getX1()), this.getY1() + this.getGrid().getRowOfs(gp.getY1()), this.getX1() + this.getGrid().getColOfs(gp.getX2() + 1) - 1, this.getY1() + this.getGrid().getRowOfs(gp.getY2() + 1) - 1);
            area.setName(name);
            int index = this.getIndex(selected.get(0));
            this.insertChild(area, index);
            area.appendChildren(selected);
            area.createGrid();
            this.createGrid();
            return area;
        }
        return null;
    }

    @Override
    public void insertParent(Area newParent, Area child) {
        int index = this.getIndex(child);
        if (index == -1) {
            throw new IllegalArgumentException("child must be a child area");
        }
        this.insertChild(newParent, index);
        newParent.appendChild(child);
    }

    @Override
    public Area copy() {
        DefaultArea ret = new DefaultArea(this);
        if (this.getParentArea() != null) {
            int ndx = this.getParentArea().getIndex(this);
            this.getParentArea().insertChild(ret, ndx + 1);
        }
        return ret;
    }

    public String toString() {
        String bs = "";
        if (this.hasTopBorder()) {
            bs = bs + "^";
        }
        if (this.hasLeftBorder()) {
            bs = bs + "<";
        }
        if (this.hasRightBorder()) {
            bs = bs + ">";
        }
        if (this.hasBottomBorder()) {
            bs = bs + "_";
        }
        if (this.isBackgroundSeparated()) {
            bs = bs + "*";
        }
        if (this.name != null) {
            return bs + " " + this.name + " " + this.getBounds().toString();
        }
        return bs + " <area> " + this.getBounds().toString();
    }

    protected String getBoxDescription(Box box) {
        if (box.getType() == Box.Type.TEXT_CONTENT) {
            return box.getText();
        }
        String cls = box.getAttribute("class");
        String id = box.getAttribute("id");
        StringBuilder ret = new StringBuilder("<");
        ret.append(box.getTagName());
        if (id != null) {
            ret.append(" id=").append(id);
        }
        if (cls != null) {
            ret.append(" class=").append(cls);
        }
        ret.append(">");
        return ret.toString();
    }
}

