/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.impl;

import java.util.List;
import org.fit.layout.impl.DefaultArea;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Box;
import org.fit.layout.model.Page;
import org.fit.layout.model.Rectangular;

public class DefaultAreaTree
implements AreaTree {
    protected Page page;
    private Area root;

    public DefaultAreaTree(Page page) {
        this.page = page;
    }

    public DefaultAreaTree(AreaTree src) {
        this.page = src.getPage();
        this.root = src.getRoot();
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    @Override
    public Area getRoot() {
        return this.root;
    }

    public void setRoot(Area root) {
        this.root = root;
    }

    @Override
    public void updateTopologies() {
    }

    @Override
    public Area getAreaAt(int x, int y) {
        return this.recursiveGetAreaAt(this.root, x, y);
    }

    private Area recursiveGetAreaAt(Area root, int x, int y) {
        if (root.getBounds().contains(x, y)) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                Area ret = this.recursiveGetAreaAt((Area)root.getChildArea(i), x, y);
                if (ret == null) continue;
                return ret;
            }
            return root;
        }
        return null;
    }

    @Override
    public Area getAreaByName(String name) {
        return this.recursiveGetAreaByName(this.root, name);
    }

    private Area recursiveGetAreaByName(Area root, String name) {
        if (root.toString().indexOf(name) != -1) {
            return root;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            Area ret = this.recursiveGetAreaByName((Area)root.getChildArea(i), name);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public Area createArea(Rectangular r) {
        return new DefaultArea(r);
    }

    @Override
    public Area createArea(Box box) {
        return new DefaultArea(box);
    }

    @Override
    public Area createArea(List<Box> boxes) {
        return new DefaultArea(boxes);
    }
}

