/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.impl;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fit.layout.impl.DefaultContentRect;
import org.fit.layout.model.Box;
import org.fit.layout.model.ContentObject;
import org.fit.layout.model.Rectangular;

public class DefaultBox
extends DefaultContentRect
implements Box {
    private boolean visible;
    private Color color;
    private String fontFamily;
    private String text;
    private ContentObject contentObject;
    private Rectangular contentBounds;
    private Rectangular visualBounds;
    private int sourceNodeId;
    private String tagName;
    private Map<String, String> attributes;
    private Box.Type type;
    private Box.DisplayType displayType;

    public DefaultBox() {
        this.visible = true;
        this.text = "";
        this.color = Color.BLACK;
        this.fontFamily = "none";
        this.tagName = "none";
        this.type = Box.Type.ELEMENT;
        this.displayType = Box.DisplayType.BLOCK;
    }

    public DefaultBox(DefaultBox src) {
        super(src);
        this.visible = src.visible;
        this.color = new Color(src.color.getRed(), src.color.getGreen(), src.color.getBlue(), src.color.getAlpha());
        this.fontFamily = new String(src.fontFamily);
        this.text = new String(src.text);
        this.contentObject = src.contentObject;
        this.tagName = new String(src.tagName);
        if (src.attributes != null) {
            this.attributes = new HashMap<String, String>(src.attributes);
        }
        this.type = src.type;
        this.displayType = src.displayType;
    }

    @Override
    public Box getChildBox(int index) {
        return (Box)((Object)this.getChildAt(index));
    }

    @Override
    public Box getParentBox() {
        return (Box)((Object)this.getParent());
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    @Override
    public String getText() {
        if (this.isLeaf()) {
            return this.text;
        }
        String ret = "";
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (ret.trim().length() > 0) {
                ret = ret + " ";
            }
            ret = ret + this.getChildBox(i).getText().trim();
        }
        return ret;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public ContentObject getContentObject() {
        return this.contentObject;
    }

    public void setContentObject(ContentObject contentObject) {
        this.contentObject = contentObject;
    }

    @Override
    public Rectangular getContentBounds() {
        return this.contentBounds;
    }

    public void setContentBounds(Rectangular contentBounds) {
        this.contentBounds = contentBounds;
    }

    @Override
    public Rectangular getVisualBounds() {
        return this.visualBounds;
    }

    public void setVisualBounds(Rectangular visualBounds) {
        this.visualBounds = visualBounds;
    }

    @Override
    public int getSourceNodeId() {
        return this.sourceNodeId;
    }

    public void setSourceNodeId(int sourceNodeId) {
        this.sourceNodeId = sourceNodeId;
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    @Override
    public String getAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    @Override
    public Map<String, String> getAttributes() {
        if (this.attributes != null) {
            return this.attributes;
        }
        return Collections.emptyMap();
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    @Override
    public Box.Type getType() {
        return this.type;
    }

    public void setType(Box.Type type) {
        this.type = type;
    }

    @Override
    public Box.DisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(Box.DisplayType displayType) {
        this.displayType = displayType;
    }

    @Override
    public int getX1() {
        return this.getVisualBounds().getX1();
    }

    @Override
    public int getY1() {
        return this.getVisualBounds().getY1();
    }

    @Override
    public int getX2() {
        return this.getVisualBounds().getX2();
    }

    @Override
    public int getY2() {
        return this.getVisualBounds().getY2();
    }

    @Override
    public int getWidth() {
        return this.getVisualBounds().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getVisualBounds().getHeight();
    }

    @Override
    public void move(int xofs, int yofs) {
        this.getVisualBounds().move(xofs, yofs);
        this.getContentBounds().move(xofs, yofs);
        super.move(xofs, yofs);
    }

    public String toString() {
        String ret = null;
        switch (this.type) {
            case ELEMENT: {
                ret = "<" + this.getTagName();
                if (this.getAttribute("id") != null) {
                    ret = ret + " id=" + this.getAttribute("id");
                }
                if (this.getAttribute("class") != null) {
                    ret = ret + " class=" + this.getAttribute("class");
                }
                ret = ret + ">";
                break;
            }
            case REPLACED_CONTENT: {
                ret = "[replaced content]";
                break;
            }
            case TEXT_CONTENT: {
                ret = "Text: " + this.getText();
            }
        }
        return ret;
    }
}

