/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.impl;

import java.awt.Color;
import org.fit.layout.impl.GenericTreeNode;
import org.fit.layout.model.Border;
import org.fit.layout.model.ContentRect;
import org.fit.layout.model.Page;
import org.fit.layout.model.Rectangular;

public class DefaultContentRect
extends GenericTreeNode
implements ContentRect {
    private static int nextid = 1;
    private int id = nextid++;
    private Page page;
    private Rectangular bounds;
    private Color backgroundColor;
    private float underline;
    private float lineThrough;
    private float fontSize;
    private float fontStyle;
    private float fontWeight;
    private boolean backgroundSeparated;
    private Border topBorder;
    private Border bottomBorder;
    private Border leftBorder;
    private Border rightBorder;

    public DefaultContentRect() {
        this.bounds = new Rectangular();
        this.topBorder = new Border();
        this.bottomBorder = new Border();
        this.leftBorder = new Border();
        this.rightBorder = new Border();
    }

    public DefaultContentRect(DefaultContentRect src) {
        this.page = src.page;
        this.bounds = new Rectangular(src.bounds);
        this.backgroundColor = src.backgroundColor == null ? null : new Color(src.backgroundColor.getRed(), src.backgroundColor.getGreen(), src.backgroundColor.getBlue());
        this.underline = src.underline;
        this.lineThrough = src.lineThrough;
        this.fontSize = src.fontSize;
        this.fontWeight = src.fontWeight;
        this.topBorder = src.topBorder;
        this.bottomBorder = src.bottomBorder;
        this.leftBorder = src.leftBorder;
        this.rightBorder = src.rightBorder;
        this.backgroundSeparated = src.backgroundSeparated;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public boolean isBackgroundSeparated() {
        return this.backgroundSeparated;
    }

    public void setBackgroundSeparated(boolean backgroundSeparated) {
        this.backgroundSeparated = backgroundSeparated;
    }

    @Override
    public float getUnderline() {
        return this.underline;
    }

    public void setUnderline(float underline) {
        this.underline = underline;
    }

    @Override
    public float getLineThrough() {
        return this.lineThrough;
    }

    public void setLineThrough(float lineThrough) {
        this.lineThrough = lineThrough;
    }

    @Override
    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    @Override
    public float getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(float fontStyle) {
        this.fontStyle = fontStyle;
    }

    @Override
    public float getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(float fontWeight) {
        this.fontWeight = fontWeight;
    }

    @Override
    public int getTopBorder() {
        return this.topBorder.getWidth();
    }

    public void setTopBorder(int width) {
        this.topBorder.setWidth(width);
        if (this.topBorder.getStyle() == Border.Style.NONE) {
            this.topBorder.setStyle(Border.Style.SOLID);
        }
    }

    @Override
    public int getBottomBorder() {
        return this.bottomBorder.getWidth();
    }

    public void setBottomBorder(int width) {
        this.bottomBorder.setWidth(width);
        if (this.bottomBorder.getStyle() == Border.Style.NONE) {
            this.bottomBorder.setStyle(Border.Style.SOLID);
        }
    }

    @Override
    public int getLeftBorder() {
        return this.leftBorder.getWidth();
    }

    public void setLeftBorder(int width) {
        this.leftBorder.setWidth(width);
        if (this.leftBorder.getStyle() == Border.Style.NONE) {
            this.leftBorder.setStyle(Border.Style.SOLID);
        }
    }

    @Override
    public int getRightBorder() {
        return this.rightBorder.getWidth();
    }

    public void setRightBorder(int width) {
        this.rightBorder.setWidth(width);
        if (this.rightBorder.getStyle() == Border.Style.NONE) {
            this.rightBorder.setStyle(Border.Style.SOLID);
        }
    }

    @Override
    public boolean hasTopBorder() {
        return this.topBorder.getStyle() != Border.Style.NONE;
    }

    @Override
    public boolean hasBottomBorder() {
        return this.bottomBorder.getStyle() != Border.Style.NONE;
    }

    @Override
    public boolean hasLeftBorder() {
        return this.leftBorder.getStyle() != Border.Style.NONE;
    }

    @Override
    public boolean hasRightBorder() {
        return this.rightBorder.getStyle() != Border.Style.NONE;
    }

    public void setBorders(int top, int right, int bottom, int left) {
        this.setTopBorder(top);
        this.setRightBorder(right);
        this.setBottomBorder(bottom);
        this.setLeftBorder(left);
    }

    @Override
    public Border getBorderStyle(Border.Side side) {
        switch (side) {
            case TOP: {
                return this.topBorder;
            }
            case LEFT: {
                return this.leftBorder;
            }
            case BOTTOM: {
                return this.bottomBorder;
            }
            case RIGHT: {
                return this.rightBorder;
            }
        }
        return null;
    }

    public void setBorderStyle(Border.Side side, Border style) {
        switch (side) {
            case TOP: {
                this.topBorder = new Border(style);
                break;
            }
            case LEFT: {
                this.leftBorder = new Border(style);
                break;
            }
            case BOTTOM: {
                this.bottomBorder = new Border(style);
                break;
            }
            case RIGHT: {
                this.rightBorder = new Border(style);
            }
        }
    }

    @Override
    public Rectangular getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangular bounds) {
        this.bounds = bounds;
    }

    @Override
    public int getBorderCount() {
        int bcnt = 0;
        if (this.hasTopBorder()) {
            ++bcnt;
        }
        if (this.hasBottomBorder()) {
            ++bcnt;
        }
        if (this.hasLeftBorder()) {
            ++bcnt;
        }
        if (this.hasRightBorder()) {
            ++bcnt;
        }
        return bcnt;
    }

    @Override
    public int getX1() {
        return this.getBounds().getX1();
    }

    @Override
    public int getY1() {
        return this.getBounds().getY1();
    }

    @Override
    public int getX2() {
        return this.getBounds().getX2();
    }

    @Override
    public int getY2() {
        return this.getBounds().getY2();
    }

    @Override
    public int getWidth() {
        return this.getBounds().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getBounds().getHeight();
    }

    @Override
    public void move(int xofs, int yofs) {
        this.getBounds().move(xofs, yofs);
        for (GenericTreeNode child : this.getChildren()) {
            if (!(child instanceof ContentRect)) continue;
            ((ContentRect)((Object)child)).move(xofs, yofs);
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultContentRect other = (DefaultContentRect)obj;
        return this.id == other.id;
    }

    public static void resetId() {
        nextid = 1;
    }
}

