/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class GenericTreeNode {
    private GenericTreeNode root;
    private GenericTreeNode parent = null;
    private Vector<GenericTreeNode> children = new Vector();
    private HashMap<Class<?>, Object> attributes;

    public GenericTreeNode() {
        this.root = this;
        this.attributes = new HashMap();
    }

    public GenericTreeNode getParent() {
        return this.parent;
    }

    public GenericTreeNode getRoot() {
        return this.root;
    }

    public boolean isRoot() {
        return this.root == this;
    }

    public <T> T getUserAttribute(Class<T> clazz) {
        return clazz.cast(this.attributes.get(clazz));
    }

    public void addUserAttribute(Object attribute) {
        this.attributes.put(attribute.getClass(), attribute);
    }

    public List<GenericTreeNode> getChildren() {
        return this.children;
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public void add(GenericTreeNode child) {
        if (child.parent != null) {
            child.parent.remove(child);
        }
        child.parent = this;
        this.children.add(child);
    }

    public void insert(GenericTreeNode child, int index) throws IndexOutOfBoundsException {
        if (child.parent != null) {
            child.parent.remove(child);
        }
        child.parent = this;
        this.children.add(index, child);
    }

    public void removeAllChildren() {
        for (GenericTreeNode child : this.children) {
            child.parent = null;
            child.root = child;
        }
        this.children.removeAllElements();
    }

    public void remove(int index) throws IndexOutOfBoundsException {
        GenericTreeNode child = this.children.elementAt(index);
        child.parent = null;
        child.root = child;
        this.children.remove(index);
    }

    public void remove(GenericTreeNode child) throws IllegalArgumentException {
        if (!this.children.remove(child)) {
            throw new IllegalArgumentException("Given node is not a child of this node");
        }
        child.parent = null;
        child.root = child;
    }

    public GenericTreeNode getChildAt(int index) throws IndexOutOfBoundsException {
        return this.children.get(index);
    }

    public int getIndex(GenericTreeNode child) {
        if (child != null) {
            return this.children.indexOf(child);
        }
        throw new IllegalArgumentException("The child cannot be null");
    }

    public GenericTreeNode getPreviousSiblingNode() {
        if (this.getParent() != null) {
            int index = this.getParent().getIndex(this);
            if (index == 0) {
                return null;
            }
            return this.getParent().getChildAt(index - 1);
        }
        return null;
    }

    public GenericTreeNode getNextSiblingNode() {
        if (this.getParent() != null) {
            int index = this.getParent().getIndex(this);
            if (index == this.getParent().getChildCount() - 1) {
                return null;
            }
            return this.getParent().getChildAt(index + 1);
        }
        return null;
    }

    public int getDepth() {
        return this.recursiveGetDepth(this);
    }

    private int recursiveGetDepth(GenericTreeNode root) {
        if (root.isLeaf()) {
            return 0;
        }
        int max = 0;
        for (GenericTreeNode child : root.getChildren()) {
            int cdepth = this.recursiveGetDepth(child);
            if (cdepth <= max) continue;
            max = cdepth;
        }
        return max + 1;
    }

    public int getLeafCount() {
        return this.recursiveGetLeafCount(this);
    }

    private int recursiveGetLeafCount(GenericTreeNode root) {
        if (root.isLeaf()) {
            return 1;
        }
        int sum = 0;
        for (GenericTreeNode child : root.getChildren()) {
            sum += this.recursiveGetLeafCount(child);
        }
        return sum;
    }
}

