/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.fit.layout.api.Parameter;
import org.fit.layout.api.ParametrizedOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseParametrizedOperation
implements ParametrizedOperation {
    private static Logger log = LoggerFactory.getLogger(BaseParametrizedOperation.class);
    private List<Parameter> params;

    @Override
    public List<Parameter> getParams() {
        if (this.params == null) {
            this.params = this.defineParams();
        }
        return this.params;
    }

    public List<Parameter> defineParams() {
        return Collections.emptyList();
    }

    @Override
    public boolean setParam(String name, Object value) {
        String sname = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        try {
            if (value instanceof Integer) {
                Method m = this.getClass().getMethod(sname, Integer.TYPE);
                m.invoke((Object)this, value);
            } else if (value instanceof Double) {
                try {
                    Method m = this.getClass().getMethod(sname, Float.TYPE);
                    m.invoke((Object)this, Float.valueOf(((Double)value).floatValue()));
                }
                catch (NoSuchMethodException e) {
                    Method m = this.getClass().getMethod(sname, Integer.TYPE);
                    m.invoke((Object)this, ((Double)value).intValue());
                }
            } else if (value instanceof Float) {
                try {
                    Method m = this.getClass().getMethod(sname, Float.TYPE);
                    m.invoke((Object)this, value);
                }
                catch (NoSuchMethodException e) {
                    Method m = this.getClass().getMethod(sname, Integer.TYPE);
                    m.invoke((Object)this, ((Double)value).intValue());
                }
            } else if (value instanceof Boolean) {
                Method m = this.getClass().getMethod(sname, Boolean.TYPE);
                m.invoke((Object)this, value);
            } else {
                Method m = this.getClass().getMethod(sname, String.class);
                m.invoke((Object)this, value.toString());
            }
            return true;
        }
        catch (NoSuchMethodException e) {
            log.warn("Setting unknown parameter: " + e.getMessage());
            return false;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return false;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Object getParam(String name) {
        String sname = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
        try {
            Method m = this.getClass().getMethod(sname, new Class[0]);
            return m.invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

