/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import org.fit.layout.api.OutputDisplay;
import org.fit.layout.impl.AreaGrid;
import org.fit.layout.impl.DefaultArea;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTopology;
import org.fit.layout.model.Rectangular;

public class DefaultGridTopology
implements AreaTopology {
    private DefaultArea area;

    public DefaultGridTopology(DefaultArea area) {
        this.area = area;
    }

    public Area getArea() {
        return this.area;
    }

    @Override
    public void update() {
        this.area.createGrid();
    }

    @Override
    public int getTopologyWidth() {
        return this.area.getGrid().getWidth();
    }

    @Override
    public int getTopologyHeight() {
        return this.area.getGrid().getHeight();
    }

    @Override
    public Rectangular getTopologyPosition() {
        return this.area.getGrid().getAbsolutePosition();
    }

    @Override
    public Rectangular getPosition(Area a) {
        if (a.getParentArea() == this.area && a instanceof DefaultArea) {
            return ((DefaultArea)a).getGridPosition();
        }
        return null;
    }

    @Override
    public void setPosition(Area a, Rectangular gp) {
        if (a.getParentArea() == this.area && a instanceof DefaultArea) {
            ((DefaultArea)a).setGridPosition(gp);
        }
    }

    @Override
    public int getWidth() {
        return this.area.getGridWidth();
    }

    @Override
    public int getHeight() {
        return this.area.getGridHeight();
    }

    @Override
    public Rectangular getPosition() {
        return this.area.getGridPosition();
    }

    @Override
    public Area getPreviousOnLine() {
        return this.area.getPreviousOnLine();
    }

    @Override
    public Area getNextOnLine() {
        return this.area.getNextOnLine();
    }

    @Override
    public int getMinIndent() {
        return this.area.getGrid().getMinIndent();
    }

    @Override
    public int getMaxIndent() {
        return this.area.getGrid().getMaxIndent();
    }

    @Override
    public void drawLayout(OutputDisplay disp) {
        Graphics2D ig = disp.getGraphics();
        AreaGrid grid = this.area.getGrid();
        Color c = ig.getColor();
        ig.setColor(Color.BLUE);
        int xo = this.getArea().getX1();
        for (int i = 1; i <= grid.getWidth(); ++i) {
            ig.drawLine(xo += grid.getCols()[i - 1], this.getArea().getY1(), xo, this.getArea().getY2());
        }
        int yo = this.getArea().getY1();
        for (int i = 0; i < grid.getHeight(); ++i) {
            ig.drawLine(this.getArea().getX1(), yo += grid.getRows()[i], this.getArea().getX2(), yo);
        }
        ig.setColor(c);
    }
}

