/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify;

import java.awt.Color;
import java.util.HashMap;
import org.fit.layout.model.Area;

public class BackgroundColorAnalyzer {
    private HashMap<Integer, Integer> colors = new HashMap();
    private Area root;
    private int totalArea;

    public BackgroundColorAnalyzer(Area root) {
        this.root = root;
        this.computeRootStatistics(this.root);
        this.totalArea = root.getBounds().getArea();
        System.err.println("We have " + this.colors.size() + " different background colors, " + this.totalArea + " total area");
    }

    public double getColorPercentage(Color color) {
        if (color == null) {
            return 0.0;
        }
        Integer num = this.colors.get(this.colorKey(color));
        if (num == null) {
            num = 0;
        }
        if (this.totalArea == 0) {
            return 0.0;
        }
        return (double)num.intValue() / (double)this.totalArea;
    }

    public double getColorPercentage(Area area) {
        if (area.isBackgroundSeparated()) {
            return this.getColorPercentage(BackgroundColorAnalyzer.getEffectiveBackgroundColor(area));
        }
        return -1.0;
    }

    private void computeRootStatistics(Area root) {
        Color color;
        if (root.isBackgroundSeparated() && (color = root.getBackgroundColor()) != null) {
            int key = this.colorKey(color);
            Integer val = this.colors.get(key);
            if (val == null) {
                val = 0;
            }
            val = val + root.getBounds().getArea();
            this.colors.put(key, val);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.computeRootStatistics((Area)root.getChildArea(i));
        }
    }

    private int colorKey(Color color) {
        return color.getRed() / 16 * 256 + color.getGreen() / 16 * 16 + color.getBlue() / 16;
    }

    public static Color getEffectiveBackgroundColor(Area area) {
        if (area.getBackgroundColor() != null) {
            return area.getBackgroundColor();
        }
        if (area.getParentArea() != null) {
            return BackgroundColorAnalyzer.getEffectiveBackgroundColor((Area)area.getParentArea());
        }
        return Color.WHITE;
    }
}

