/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class StyleCounter<T> {
    private Map<T, Integer> styles = new HashMap<T, Integer>();

    public void add(T style) {
        Integer cnt = this.styles.get(style);
        if (cnt == null) {
            this.styles.put(style, 1);
        } else {
            this.styles.put(style, cnt + 1);
        }
    }

    public int getCount(T style) {
        Integer cnt = this.styles.get(style);
        return cnt == null ? 0 : cnt;
    }

    public T getMostFrequent() {
        T ret = null;
        int freq = 0;
        for (Map.Entry<T, Integer> entry : this.styles.entrySet()) {
            if (entry.getValue() <= freq) continue;
            ret = entry.getKey();
            freq = entry.getValue();
        }
        return ret;
    }

    public List<T> getMostFrequentAll() {
        Vector<T> ret = new Vector<T>();
        int maxfreq = 0;
        for (Map.Entry<T, Integer> entry : this.styles.entrySet()) {
            if (entry.getValue() <= maxfreq) continue;
            maxfreq = entry.getValue();
        }
        for (Map.Entry<T, Integer> entry : this.styles.entrySet()) {
            if (entry.getValue() != maxfreq) continue;
            ret.add(entry.getKey());
        }
        return ret;
    }
}

