/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import org.fit.layout.classify.FeatureExtractor;
import org.fit.layout.model.Area;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.trees.J48;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Standardize;

public class VisualClassifier {
    private Filter filter;
    private AbstractClassifier classifier;
    private Instances trainset;
    private Instances testset;
    private HashMap<Area, Instance> mapping;
    private Area testRoot;
    private FeatureExtractor features;

    public VisualClassifier(String trainfile, int classindex) {
        this.train(trainfile, classindex);
    }

    public void classifyTree(Area root, FeatureExtractor features) {
        if (this.classifier != null) {
            System.out.print("tree visual classification...");
            this.testRoot = root;
            this.features = features;
            this.testset = new Instances(this.trainset, 0);
            this.mapping = new HashMap();
            this.recursivelyExtractAreaData(this.testRoot);
            System.out.println("done");
        }
    }

    public String classifyArea(Area area) {
        if (this.mapping != null) {
            Instance data = this.mapping.get(area);
            if (data != null) {
                try {
                    double n = this.classifier.classifyInstance(data);
                    return this.getClassName((int)n);
                }
                catch (Exception e) {
                    System.out.println("classifyArea: error: " + e.getMessage());
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public String getClassName(int index) {
        return this.trainset.classAttribute().value(index);
    }

    private void train(String resource, int classindex) {
        try {
            InputStream is = resource.startsWith("res:") ? ClassLoader.getSystemResourceAsStream(resource.substring(4)) : new FileInputStream(resource);
            ConverterUtils.DataSource source = new ConverterUtils.DataSource(is);
            Instances tdata = source.getDataSet();
            tdata.setClassIndex(classindex);
            System.err.print("filter...");
            this.filter = new Standardize();
            this.trainset = tdata;
            System.err.print("build...");
            J48 cls = new J48();
            cls.setOptions(Utils.splitOptions((String)"-C 0.25 -M 2"));
            FilteredClassifier fc = new FilteredClassifier();
            fc.setFilter(this.filter);
            fc.setClassifier((Classifier)cls);
            this.classifier = fc;
            this.classifier.buildClassifier(this.trainset);
            if (cls instanceof J48) {
                System.out.println(cls.toString());
            }
            is.close();
        }
        catch (Exception e) {
            this.classifier = null;
            System.err.println("Classifier training failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void recursivelyExtractAreaData(Area root) {
        Instance data = this.features.getAreaFeatures(root, this.testset);
        this.testset.add(data);
        this.mapping.put(root, data);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursivelyExtractAreaData((Area)root.getChildArea(i));
        }
    }
}

