/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify.op;

import java.util.List;
import java.util.Vector;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.classify.Tagger;
import org.fit.layout.classify.TreeTagger;
import org.fit.layout.classify.taggers.DateTagger;
import org.fit.layout.classify.taggers.LocationsTagger;
import org.fit.layout.classify.taggers.PagesTagger;
import org.fit.layout.classify.taggers.PersonsTagger;
import org.fit.layout.classify.taggers.TimeTagger;
import org.fit.layout.classify.taggers.TitleTagger;
import org.fit.layout.impl.BaseOperator;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;

public class TagEntitiesOperator
extends BaseOperator {
    protected final String[] paramNames = new String[0];
    protected final ParametrizedOperation.ValueType[] paramTypes = new ParametrizedOperation.ValueType[0];
    private TreeTagger tagger;
    private List<Tagger> taggers;

    public TagEntitiesOperator() {
        this.initTaggers();
    }

    public String getId() {
        return "FitLayout.Tag.Entities";
    }

    public String getName() {
        return "Tag entities";
    }

    public String getDescription() {
        return "...";
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public ParametrizedOperation.ValueType[] getParamTypes() {
        return this.paramTypes;
    }

    public void addTagger(Tagger tagger) {
        this.taggers.add(tagger);
    }

    protected void initTaggers() {
        TimeTagger tTime = new TimeTagger();
        DateTagger tDate = new DateTagger();
        PersonsTagger tPersons = new PersonsTagger(1);
        LocationsTagger tLoc = new LocationsTagger(1);
        TitleTagger tTitle = new TitleTagger();
        PagesTagger tPages = new PagesTagger();
        this.taggers = new Vector<Tagger>();
        this.taggers.add(tTime);
        this.taggers.add(tDate);
        this.taggers.add(tPersons);
        this.taggers.add(tLoc);
        this.taggers.add(tTitle);
        this.taggers.add(tPages);
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        this.tagger = new TreeTagger(root);
        for (Tagger t : this.taggers) {
            this.tagger.addTagger(t);
        }
        this.tagger.tagTree();
    }
}

