/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify.op;

import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.classify.FeatureExtractor;
import org.fit.layout.classify.VisualClassifier;
import org.fit.layout.classify.VisualTag;
import org.fit.layout.classify.articles.ArticleFeatureExtractor;
import org.fit.layout.impl.BaseOperator;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Tag;

public class VisualClassificationOperator
extends BaseOperator {
    private final String[] paramNames = new String[]{"trainFile", "classIndex"};
    private final ParametrizedOperation.ValueType[] paramTypes = new ParametrizedOperation.ValueType[]{ParametrizedOperation.ValueType.STRING, ParametrizedOperation.ValueType.INTEGER};
    private String trainFile;
    private int classIndex;
    private FeatureExtractor features;
    private VisualClassifier vcls;

    public VisualClassificationOperator() {
        this.features = new ArticleFeatureExtractor();
    }

    public VisualClassificationOperator(String trainFile, int classIndex) {
        this.trainFile = trainFile;
        this.classIndex = classIndex;
    }

    public String getId() {
        return "FitLayout.Tag.Visual";
    }

    public String getName() {
        return "Tag visual classes";
    }

    public String getDescription() {
        return "...";
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public ParametrizedOperation.ValueType[] getParamTypes() {
        return this.paramTypes;
    }

    public String getTrainFile() {
        return this.trainFile;
    }

    public void setTrainFile(String trainFile) {
        this.trainFile = trainFile;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public void setClassIndex(int classIndex) {
        this.classIndex = classIndex;
    }

    public FeatureExtractor getFeatures() {
        return this.features;
    }

    public void setFeatures(FeatureExtractor features) {
        this.features = features;
    }

    public VisualClassifier getVisualClassifier() {
        return this.vcls;
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        this.features.setTree(root);
        System.out.println("SETTING ROOT");
        this.vcls = new VisualClassifier(this.trainFile, this.classIndex);
        this.vcls.classifyTree(root, this.features);
        this.recursivelyAddTags(root);
    }

    private void recursivelyAddTags(Area root) {
        String cls = this.vcls.classifyArea(root);
        if (cls != null && !cls.isEmpty() && !cls.equals("none")) {
            VisualTag tag = new VisualTag(cls);
            root.addTag((Tag)tag, 0.9f);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursivelyAddTags((Area)root.getChildArea(i));
        }
    }
}

