/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify.taggers;

import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fit.layout.classify.Tagger;
import org.fit.layout.classify.TextTag;
import org.fit.layout.model.Area;
import org.fit.layout.model.Tag;

public class PagesTagger
implements Tagger {
    protected Pattern pgexpr = Pattern.compile("[1-9][0-9]*(\\s*\\p{Pd}\\s*[1-9][0-9]*)?");

    @Override
    public TextTag getTag() {
        return new TextTag("pages", this);
    }

    @Override
    public double getRelevance() {
        return 0.95;
    }

    @Override
    public boolean belongsTo(Area node) {
        if (node.isLeaf()) {
            String text = node.getText();
            Matcher match = this.pgexpr.matcher(text);
            while (match.find()) {
                int ms = match.start();
                int me = match.end();
                if (ms != 0 && text.charAt(ms) != ' ' || me != text.length() && text.charAt(ms) != ' ') continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean allowsContinuation(Area node) {
        return false;
    }

    @Override
    public boolean allowsJoining() {
        return false;
    }

    @Override
    public boolean mayCoexistWith(Tag other) {
        return true;
    }

    @Override
    public Vector<String> extract(String src) {
        Vector<String> ret = new Vector<String>();
        Matcher match = this.pgexpr.matcher(src);
        while (match.find()) {
            String s = match.group();
            ret.add(s);
        }
        return ret;
    }
}

