/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify.taggers;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.util.Triple;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.fit.layout.classify.Tagger;
import org.fit.layout.classify.TextTag;
import org.fit.layout.classify.TreeTagger;
import org.fit.layout.model.Area;
import org.fit.layout.model.Tag;

public class PersonsTagger
implements Tagger {
    protected Pattern contexpr = Pattern.compile("[A-Z][A-Za-z]");
    private int mincnt;
    private AbstractSequenceClassifier<?> classifier;

    public PersonsTagger(int mincnt) {
        this.mincnt = mincnt;
        this.classifier = TreeTagger.sharedClassifier;
    }

    @Override
    public TextTag getTag() {
        return new TextTag("persons", this);
    }

    @Override
    public double getRelevance() {
        return 0.8;
    }

    @Override
    public boolean belongsTo(Area node) {
        if (node.isLeaf()) {
            String text = node.getText();
            List list = this.classifier.classifyToCharacterOffsets(text);
            int cnt = 0;
            for (Triple t : list) {
                if (((String)t.first()).equals("PERSON")) {
                    ++cnt;
                }
                if (cnt < this.mincnt) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean allowsContinuation(Area node) {
        String text;
        return node.isLeaf() && this.contexpr.matcher(text = node.getText().trim()).lookingAt();
    }

    @Override
    public boolean mayCoexistWith(Tag other) {
        return true;
    }

    @Override
    public boolean allowsJoining() {
        return true;
    }

    @Override
    public Vector<String> extract(String src) {
        Vector<String> ret = new Vector<String>();
        List list = this.classifier.classifyToCharacterOffsets(src);
        for (Triple t : list) {
            if (!((String)t.first()).equals("PERSON")) continue;
            ret.add(src.substring((Integer)t.second(), (Integer)t.third()));
        }
        return ret;
    }
}

