/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify.taggers;

import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fit.layout.classify.Tagger;
import org.fit.layout.classify.TextTag;
import org.fit.layout.model.Area;
import org.fit.layout.model.Tag;

public class SessionTagger
implements Tagger {
    protected final int MIN_WORDS = 2;
    protected Pattern areaexpr = Pattern.compile("[A-Z0-9]");
    protected Pattern titleexpr = Pattern.compile("[A-Z][A-Za-z0-9\\s\\:\\-\\p{Pd}]*");
    protected Pattern contexpr = Pattern.compile("[A-Za-z\\s\\:\\-\\p{Pd}]+");
    protected Vector<String> whitelist = new Vector();
    protected Vector<String> blacklist = new Vector();

    public SessionTagger() {
        this.blacklist.add("chair");
    }

    @Override
    public TextTag getTag() {
        return new TextTag("session", this);
    }

    @Override
    public double getRelevance() {
        return 0.6;
    }

    @Override
    public boolean belongsTo(Area node) {
        String text;
        if (node.isLeaf() && this.areaexpr.matcher(text = node.getText().trim()).lookingAt()) {
            Matcher match = this.titleexpr.matcher(text);
            while (match.find()) {
                String s = match.group();
                String[] words = s.split("\\s+");
                if (words.length < 2 || this.containsListedWord(this.blacklist, words)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean allowsContinuation(Area node) {
        String text;
        return node.isLeaf() && this.contexpr.matcher(text = node.getText().trim()).lookingAt();
    }

    @Override
    public boolean allowsJoining() {
        return true;
    }

    @Override
    public boolean mayCoexistWith(Tag other) {
        return !other.getValue().equals("persons") && !other.getValue().equals("title");
    }

    @Override
    public Vector<String> extract(String src) {
        Vector<String> ret = new Vector<String>();
        Matcher match = this.titleexpr.matcher(src);
        while (match.find()) {
            String s = match.group();
            String[] words = s.split("\\s+");
            if (words.length < 2) continue;
            ret.add(s);
        }
        return ret;
    }

    protected boolean containsListedWord(Vector<String> list, String[] words) {
        for (String w : words) {
            if (!list.contains(w.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

