/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.annotator;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.fit.layout.api.PageSet;
import org.fit.layout.api.PageSetStorage;
import org.fit.layout.api.PageStorage;
import org.fit.layout.api.ScriptObject;
import org.fit.layout.api.ServiceManager;
import org.fit.layout.gui.AreaSelectionListener;
import org.fit.layout.gui.Browser;
import org.fit.layout.gui.BrowserPlugin;
import org.fit.layout.gui.GUIUpdateListener;
import org.fit.layout.gui.TreeListener;
import org.fit.layout.impl.DefaultTag;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.LogicalAreaTree;
import org.fit.layout.model.Page;
import org.fit.layout.model.Tag;

public class AnnotatorPlugin
implements BrowserPlugin,
AreaSelectionListener,
TreeListener,
GUIUpdateListener,
ScriptObject {
    private Browser browser;
    private PageStorage pageStorage;
    private PageSetStorage setStorage;
    private String[] tags = new String[]{"none"};
    private Area selectedArea;
    private boolean tagsChanged;
    private JPanel pnl_mainPanel;
    private JPanel pnl_selection;
    private JComboBox<String> cbx_tagSelector;
    private JPanel pnl_control;
    private JButton btn_addTag;
    private JButton btn_removeTag;
    private JScrollPane scrl_tagTable;
    private JTable tagTable;
    private DefaultTableModel tagTableModel;
    private JPanel pnl_settings;
    private JCheckBox chckbxHighlightTags;
    private JPanel pnl_info;
    private JTextField txtType;
    private JPanel storageButtonPanel;
    private JButton btnPrevious;
    private JButton btnNext;
    private JLabel lblSelectionStatus;
    private JButton btnSave;
    private JButton btnSaveNext;

    public boolean init(Browser browser) {
        this.browser = browser;
        this.browser.addToolPanel("Annotator", (JComponent)this.getPnl_mainPanel());
        this.browser.addAreaSelectionListener((AreaSelectionListener)this);
        for (PageStorage service : ServiceManager.findPageStorages().values()) {
            if (!(service instanceof PageSetStorage)) continue;
            this.pageStorage = service;
            this.setStorage = (PageSetStorage)service;
            service.registerGUIUpdateListener((GUIUpdateListener)this);
            break;
        }
        this.updateStorageStatus();
        return true;
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
        this.cbx_tagSelector.removeAllItems();
        for (String tag : this.tags) {
            this.cbx_tagSelector.addItem(tag);
        }
    }

    public void areaSelected(Area area) {
        this.selectedArea = area;
        this.updateTableModel();
        this.getBtn_addTag().setEnabled(area != null);
    }

    public void pageRendered(Page page) {
        this.tagsChanged = false;
        this.updateGUI();
    }

    public void areaTreeUpdated(AreaTree tree) {
        this.tagsChanged = false;
        this.updateGUI();
    }

    public void logicalAreaTreeUpdated(LogicalAreaTree tree) {
        this.updateGUI();
    }

    public void updateGUI() {
        this.updateStorageStatus();
        this.highlightTags();
    }

    private void updateTableModel() {
        this.tagTableModel.setRowCount(0);
        if (this.selectedArea != null) {
            for (Map.Entry tagEntry : this.selectedArea.getTags().entrySet()) {
                Tag tag = (Tag)tagEntry.getKey();
                Float support = (Float)tagEntry.getValue();
                this.tagTableModel.addRow(new Object[]{tag.getType(), tag.getValue(), support});
            }
        }
    }

    private void updateStorageStatus() {
        if (this.setStorage != null) {
            PageSet pset = this.setStorage.getCurrentPageSet();
            int sel = this.setStorage.getCurrentIndex();
            if (pset == null) {
                this.lblSelectionStatus.setText("No page set loaded");
            } else if (sel == -1) {
                this.lblSelectionStatus.setText("Page set " + pset.getName() + ": No page loaded");
            } else {
                this.lblSelectionStatus.setText("Page set " + pset.getName() + ": Page " + (sel + 1) + " / " + this.setStorage.getTotalCount());
            }
            this.btnPrevious.setEnabled(this.setStorage.previousPageAvailable());
            this.btnNext.setEnabled(this.setStorage.nextPageAvailable());
            if (this.pageStorage.updateAvailable()) {
                this.btnSave.setText("Save changes" + (this.tagsChanged ? "*" : ""));
                this.btnSave.setEnabled(true);
                this.btnSaveNext.setEnabled(this.setStorage.nextPageAvailable());
            } else if (this.pageStorage.saveAvailable()) {
                this.btnSave.setText("Save as new" + (this.tagsChanged ? "*" : ""));
                this.btnSave.setEnabled(true);
                this.btnSaveNext.setEnabled(false);
            } else {
                this.btnSave.setEnabled(false);
                this.btnSaveNext.setEnabled(false);
            }
        } else {
            this.lblSelectionStatus.setText("(no storage available)");
            this.btnPrevious.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSaveNext.setEnabled(false);
        }
    }

    public void highlightTags() {
        if (this.getChckbxHighlightTags().isSelected()) {
            this.browser.redrawPage();
            if (this.browser.getAreaTree() != null && this.browser.getAreaTree().getRoot() != null) {
                String type = this.getTxtType().getText();
                this.recursiveColorizeTags(this.browser.getAreaTree().getRoot(), type);
            }
            this.browser.updateDisplay();
        }
    }

    private void recursiveColorizeTags(Area root, String type) {
        HashSet<Tag> tags = new HashSet<Tag>();
        for (Tag tag : root.getTags().keySet()) {
            if (!tag.getType().equals(type)) continue;
            tags.add(tag);
        }
        this.browser.getOutputDisplay().colorizeByTags(root, tags);
        for (Area child : root.getChildAreas()) {
            this.recursiveColorizeTags(child, type);
        }
    }

    private boolean confirmDiscard(Component parentComponent) {
        int result = JOptionPane.showConfirmDialog(this.btnNext, new String[]{"Tags have been altered in the current page.", "Do you really want to leave the page and discard changes?"}, "Discard changes?", 0, 3);
        return result == 0;
    }

    public String getVarName() {
        return "annotator";
    }

    public void setIO(Reader in, Writer out, Writer err) {
    }

    public void setTagType(String type) {
        this.getTxtType().setText(type);
    }

    public String getTagType() {
        return this.getTxtType().getText();
    }

    private JPanel getPnl_mainPanel() {
        if (this.pnl_mainPanel == null) {
            this.pnl_mainPanel = new JPanel();
            GridBagLayout gbl_pathsPanel = new GridBagLayout();
            gbl_pathsPanel.columnWeights = new double[]{0.0, 1.0, 1.0};
            gbl_pathsPanel.rowWeights = new double[]{0.05, 0.05, 0.0, 0.0};
            this.pnl_mainPanel.setLayout(gbl_pathsPanel);
            GridBagConstraints gbc_selection = new GridBagConstraints();
            gbc_selection.insets = new Insets(0, 0, 5, 5);
            gbc_selection.fill = 2;
            gbc_selection.gridx = 0;
            gbc_selection.gridy = 0;
            this.pnl_mainPanel.add((Component)this.getPnl_selection(), gbc_selection);
            GridBagConstraints gbc_control = new GridBagConstraints();
            gbc_control.insets = new Insets(0, 0, 5, 5);
            gbc_control.fill = 2;
            gbc_control.gridx = 0;
            gbc_control.gridy = 1;
            this.pnl_mainPanel.add((Component)this.getPnl_control(), gbc_control);
            GridBagConstraints gbc_extractionScroll = new GridBagConstraints();
            gbc_extractionScroll.insets = new Insets(0, 0, 0, 5);
            gbc_extractionScroll.weighty = 1.0;
            gbc_extractionScroll.gridheight = 4;
            gbc_extractionScroll.fill = 1;
            gbc_extractionScroll.gridx = 1;
            gbc_extractionScroll.gridy = 0;
            this.pnl_mainPanel.add((Component)this.getScrl_tagTable(), gbc_extractionScroll);
            GridBagConstraints gbc_pnl_settings = new GridBagConstraints();
            gbc_pnl_settings.insets = new Insets(0, 0, 5, 5);
            gbc_pnl_settings.fill = 1;
            gbc_pnl_settings.gridx = 0;
            gbc_pnl_settings.gridy = 2;
            this.pnl_mainPanel.add((Component)this.getPnl_settings(), gbc_pnl_settings);
            GridBagConstraints gbc_pnl_info = new GridBagConstraints();
            gbc_pnl_info.insets = new Insets(0, 0, 5, 0);
            gbc_pnl_info.weighty = 1.0;
            gbc_pnl_info.weightx = 1.0;
            gbc_pnl_info.gridheight = 2;
            gbc_pnl_info.fill = 1;
            gbc_pnl_info.gridx = 2;
            gbc_pnl_info.gridy = 0;
            this.pnl_mainPanel.add((Component)this.getPanel_1(), gbc_pnl_info);
            GridBagConstraints gbc_lblSelectionStatus = new GridBagConstraints();
            gbc_lblSelectionStatus.anchor = 14;
            gbc_lblSelectionStatus.insets = new Insets(0, 0, 5, 5);
            gbc_lblSelectionStatus.gridx = 2;
            gbc_lblSelectionStatus.gridy = 2;
            this.pnl_mainPanel.add((Component)this.getLblSelectionStatus(), gbc_lblSelectionStatus);
            GridBagConstraints gbc_storageButtonPanel = new GridBagConstraints();
            gbc_storageButtonPanel.anchor = 13;
            gbc_storageButtonPanel.fill = 3;
            gbc_storageButtonPanel.gridx = 2;
            gbc_storageButtonPanel.gridy = 3;
            this.pnl_mainPanel.add((Component)this.getStorageButtonPanel(), gbc_storageButtonPanel);
        }
        return this.pnl_mainPanel;
    }

    private JPanel getPnl_selection() {
        if (this.pnl_selection == null) {
            this.pnl_selection = new JPanel();
            GridBagLayout gbl_pnl_selection = new GridBagLayout();
            gbl_pnl_selection.columnWeights = new double[]{1.0};
            gbl_pnl_selection.rowWeights = new double[]{0.0, 0.0};
            this.pnl_selection.setLayout(gbl_pnl_selection);
            GridBagConstraints gbc_txtType = new GridBagConstraints();
            gbc_txtType.fill = 1;
            gbc_txtType.insets = new Insets(5, 5, 0, 5);
            gbc_txtType.gridx = 0;
            gbc_txtType.gridy = 0;
            this.pnl_selection.add((Component)this.getTxtType(), gbc_txtType);
            GridBagConstraints gbc_cbx_tagSelector = new GridBagConstraints();
            gbc_cbx_tagSelector.insets = new Insets(0, 5, 0, 5);
            gbc_cbx_tagSelector.fill = 2;
            gbc_cbx_tagSelector.gridx = 0;
            gbc_cbx_tagSelector.gridy = 1;
            this.pnl_selection.add(this.getCbx_tagSelection(), gbc_cbx_tagSelector);
        }
        return this.pnl_selection;
    }

    private JComboBox<String> getCbx_tagSelection() {
        if (this.cbx_tagSelector == null) {
            this.cbx_tagSelector = new JComboBox();
            for (String tag : this.tags) {
                this.cbx_tagSelector.addItem(tag);
            }
        }
        return this.cbx_tagSelector;
    }

    private JPanel getPnl_control() {
        if (this.pnl_control == null) {
            this.pnl_control = new JPanel();
            this.pnl_control.setLayout(new FlowLayout(1));
            this.pnl_control.add(this.getBtn_addTag());
            this.pnl_control.add(this.getBtn_removeTag());
        }
        return this.pnl_control;
    }

    private JButton getBtn_addTag() {
        if (this.btn_addTag == null) {
            this.btn_addTag = new JButton("Assign");
            this.btn_addTag.setEnabled(false);
            this.btn_addTag.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (AnnotatorPlugin.this.selectedArea != null) {
                        DefaultTag tag = new DefaultTag(AnnotatorPlugin.this.txtType.getText(), AnnotatorPlugin.this.cbx_tagSelector.getSelectedItem().toString());
                        AnnotatorPlugin.this.selectedArea.addTag((Tag)tag, 1.0f);
                        AnnotatorPlugin.this.updateTableModel();
                        AnnotatorPlugin.this.highlightTags();
                        if (!AnnotatorPlugin.this.tagsChanged) {
                            AnnotatorPlugin.this.tagsChanged = true;
                            AnnotatorPlugin.this.updateStorageStatus();
                        }
                    }
                }
            });
        }
        return this.btn_addTag;
    }

    private JButton getBtn_removeTag() {
        if (this.btn_removeTag == null) {
            this.btn_removeTag = new JButton("Remove");
            this.btn_removeTag.setEnabled(false);
            this.btn_removeTag.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int row = AnnotatorPlugin.this.tagTable.getSelectedRow();
                    if (row != -1) {
                        DefaultTag tag = new DefaultTag(AnnotatorPlugin.this.tagTableModel.getValueAt(row, 0).toString(), AnnotatorPlugin.this.tagTableModel.getValueAt(row, 1).toString());
                        if (AnnotatorPlugin.this.selectedArea != null) {
                            AnnotatorPlugin.this.selectedArea.removeTag((Tag)tag);
                        }
                        AnnotatorPlugin.this.updateTableModel();
                        AnnotatorPlugin.this.highlightTags();
                        if (!AnnotatorPlugin.this.tagsChanged) {
                            AnnotatorPlugin.this.tagsChanged = true;
                            AnnotatorPlugin.this.updateStorageStatus();
                        }
                    }
                }
            });
        }
        return this.btn_removeTag;
    }

    private JScrollPane getScrl_tagTable() {
        if (this.scrl_tagTable == null) {
            this.scrl_tagTable = new JScrollPane();
            this.scrl_tagTable.setViewportView(this.getTbl_classificationTags());
        }
        return this.scrl_tagTable;
    }

    private JTable getTbl_classificationTags() {
        if (this.tagTable == null) {
            this.tagTableModel = new DefaultTableModel(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this.tagTableModel.addColumn("Type");
            this.tagTableModel.addColumn("Name");
            this.tagTableModel.addColumn("Support");
            this.tagTable = new JTable(this.tagTableModel);
            this.tagTable.setSelectionMode(0);
            this.tagTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent ev) {
                    AnnotatorPlugin.this.getBtn_removeTag().setEnabled(AnnotatorPlugin.this.tagTable.getSelectedRow() != -1);
                }
            });
        }
        return this.tagTable;
    }

    private JPanel getPnl_settings() {
        if (this.pnl_settings == null) {
            this.pnl_settings = new JPanel();
            this.pnl_settings.add(this.getChckbxHighlightTags());
        }
        return this.pnl_settings;
    }

    private JCheckBox getChckbxHighlightTags() {
        if (this.chckbxHighlightTags == null) {
            this.chckbxHighlightTags = new JCheckBox("Highlight tags");
            this.chckbxHighlightTags.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AnnotatorPlugin.this.chckbxHighlightTags.isSelected()) {
                        AnnotatorPlugin.this.highlightTags();
                    } else {
                        AnnotatorPlugin.this.browser.redrawPage();
                        AnnotatorPlugin.this.browser.updateDisplay();
                    }
                }
            });
        }
        return this.chckbxHighlightTags;
    }

    private JPanel getPanel_1() {
        if (this.pnl_info == null) {
            this.pnl_info = new JPanel();
        }
        return this.pnl_info;
    }

    public JTextField getTxtType() {
        if (this.txtType == null) {
            this.txtType = new JTextField();
            this.txtType.setText("FitLayout.Annotate");
            this.txtType.setColumns(10);
        }
        return this.txtType;
    }

    private JPanel getStorageButtonPanel() {
        if (this.storageButtonPanel == null) {
            this.storageButtonPanel = new JPanel();
            FlowLayout flowLayout = (FlowLayout)this.storageButtonPanel.getLayout();
            flowLayout.setAlignment(2);
            this.storageButtonPanel.add(this.getBtnSaveNext());
            this.storageButtonPanel.add(this.getBtnSave());
            this.storageButtonPanel.add(this.getBtnPrevious());
            this.storageButtonPanel.add(this.getBtnNext());
        }
        return this.storageButtonPanel;
    }

    private JButton getBtnPrevious() {
        if (this.btnPrevious == null) {
            this.btnPrevious = new JButton("<");
            this.btnPrevious.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AnnotatorPlugin.this.setStorage != null && AnnotatorPlugin.this.setStorage.previousPageAvailable()) {
                        if (AnnotatorPlugin.this.tagsChanged && AnnotatorPlugin.this.confirmDiscard(AnnotatorPlugin.this.btnNext)) {
                            AnnotatorPlugin.this.tagsChanged = false;
                        }
                        if (!AnnotatorPlugin.this.tagsChanged) {
                            AnnotatorPlugin.this.setStorage.loadPrevious();
                            AnnotatorPlugin.this.updateStorageStatus();
                        }
                    }
                }
            });
        }
        return this.btnPrevious;
    }

    private JButton getBtnNext() {
        if (this.btnNext == null) {
            this.btnNext = new JButton(">");
            this.btnNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (AnnotatorPlugin.this.setStorage != null && AnnotatorPlugin.this.setStorage.nextPageAvailable()) {
                        if (AnnotatorPlugin.this.tagsChanged && AnnotatorPlugin.this.confirmDiscard(AnnotatorPlugin.this.btnNext)) {
                            AnnotatorPlugin.this.tagsChanged = false;
                        }
                        if (!AnnotatorPlugin.this.tagsChanged) {
                            AnnotatorPlugin.this.setStorage.loadNext();
                            AnnotatorPlugin.this.updateStorageStatus();
                        }
                    }
                }
            });
        }
        return this.btnNext;
    }

    private JLabel getLblSelectionStatus() {
        if (this.lblSelectionStatus == null) {
            this.lblSelectionStatus = new JLabel("No page selected");
        }
        return this.lblSelectionStatus;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton("Save");
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AnnotatorPlugin.this.pageStorage.updateAvailable()) {
                        AnnotatorPlugin.this.pageStorage.updateCurrentPage();
                        AnnotatorPlugin.this.tagsChanged = false;
                    } else if (AnnotatorPlugin.this.pageStorage.saveAvailable()) {
                        AnnotatorPlugin.this.pageStorage.saveCurrentPage();
                        AnnotatorPlugin.this.tagsChanged = false;
                    }
                    AnnotatorPlugin.this.updateGUI();
                }
            });
        }
        return this.btnSave;
    }

    private JButton getBtnSaveNext() {
        if (this.btnSaveNext == null) {
            this.btnSaveNext = new JButton("Save&Next");
            this.btnSaveNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AnnotatorPlugin.this.pageStorage.updateAvailable()) {
                        AnnotatorPlugin.this.pageStorage.updateCurrentPage();
                        AnnotatorPlugin.this.tagsChanged = false;
                        if (AnnotatorPlugin.this.setStorage != null && AnnotatorPlugin.this.setStorage.nextPageAvailable()) {
                            AnnotatorPlugin.this.setStorage.loadNext();
                        }
                    }
                }
            });
        }
        return this.btnSaveNext;
    }
}

