/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify.op;

import java.util.HashSet;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.impl.BaseOperator;
import org.fit.layout.impl.DefaultTag;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Tag;

public class CompareTagsOperator
extends BaseOperator {
    protected final String[] paramNames = new String[]{"srcType", "destType"};
    protected final ParametrizedOperation.ValueType[] paramTypes = new ParametrizedOperation.ValueType[]{ParametrizedOperation.ValueType.STRING, ParametrizedOperation.ValueType.STRING};
    private String srcType;
    private String destType;
    private int tp;
    private int fp;
    private int tn;
    private int fn;

    public CompareTagsOperator() {
        this.srcType = "FitLayout.Annotate";
        this.destType = "FitLayout.VisualTag";
    }

    public CompareTagsOperator(String srcType, String destType) {
        this.srcType = srcType;
        this.destType = destType;
    }

    public String getId() {
        return "FitLayout.Tag.Compare";
    }

    public String getName() {
        return "Compare tags";
    }

    public String getDescription() {
        return "Compares the assigned tags of two different types and prits out statistics";
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public ParametrizedOperation.ValueType[] getParamTypes() {
        return this.paramTypes;
    }

    public String getSrcType() {
        return this.srcType;
    }

    public void setSrcType(String srcType) {
        this.srcType = srcType;
    }

    public String getDestType() {
        return this.destType;
    }

    public void setDestType(String destType) {
        this.destType = destType;
    }

    public void printStatistics() {
        double p = 0.0;
        double r = 0.0;
        double f = 0.0;
        if (this.tp + this.fp > 0) {
            p = (double)this.tp / (double)(this.tp + this.fp);
        }
        if (this.tp + this.fn > 0) {
            r = (double)this.tp / (double)(this.tp + this.fn);
        }
        if (p + r > 0.0) {
            f = 2.0 * (p * r / (p + r));
        }
        System.out.println("TP=" + this.tp + " FP=" + this.fp + " TN=" + this.tn + " FN=" + this.fn);
        System.out.println("P=" + p + " R=" + r + " F=" + f);
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        this.fn = 0;
        this.tn = 0;
        this.fp = 0;
        this.tp = 0;
        this.recursiveCheckAreas(root);
        this.printStatistics();
    }

    private void recursiveCheckAreas(Area root) {
        HashSet<String> names = new HashSet<String>();
        for (Tag tag : root.getTags().keySet()) {
            if (!this.srcType.equals(tag.getType()) && !this.destType.equals(tag.getType())) continue;
            names.add(tag.getValue());
        }
        for (String name : names) {
            this.checkTag(root, name);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveCheckAreas((Area)root.getChildArea(i));
        }
    }

    private void checkTag(Area a, String name) {
        DefaultTag tsrc = new DefaultTag(this.srcType, name);
        DefaultTag tdest = new DefaultTag(this.destType, name);
        boolean hasSrc = a.hasTag((Tag)tsrc);
        boolean hasDest = a.hasTag((Tag)tdest);
        if (hasSrc || hasDest) {
            System.out.println("TAG;;" + a.getText() + ";;" + name);
        }
        if (hasDest) {
            if (hasSrc) {
                ++this.tp;
            } else {
                ++this.fp;
            }
        } else if (hasSrc) {
            ++this.fn;
        } else {
            ++this.tn;
        }
    }
}

