/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify.taggers;

import edu.stanford.nlp.util.Triple;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.classify.TextTag;
import org.fit.layout.classify.taggers.NERTagger;
import org.fit.layout.model.Area;
import org.fit.layout.model.Tag;

public class PersonsTagger
extends NERTagger {
    private static final float YES = 0.8f;
    private static final float COULDBE = 0.1f;
    private static final float NO = 0.0f;
    protected Pattern couldexpr = Pattern.compile("\\p{Lu}[\\p{L}&&[^\\p{Lu}]]+\\s+\\p{Lu}[\\p{L}&&[^\\p{Lu}]]+");
    protected Pattern contexpr = Pattern.compile("[A-Z][A-Za-z]");
    private int mincnt;

    public PersonsTagger() {
        this.mincnt = 1;
    }

    public PersonsTagger(int mincnt) {
        this.mincnt = mincnt;
    }

    public String getId() {
        return "FITLayout.Tag.Person";
    }

    public String getName() {
        return "Persons";
    }

    public String getDescription() {
        return "NER-based personal name area tagger. It tags the areas that contain at least the specified number of personal names.";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"mincnt"};
    }

    @Override
    public ParametrizedOperation.ValueType[] getParamTypes() {
        return new ParametrizedOperation.ValueType[]{ParametrizedOperation.ValueType.INTEGER};
    }

    public int getMincnt() {
        return this.mincnt;
    }

    public void setMincnt(int mincnt) {
        this.mincnt = mincnt;
    }

    @Override
    public TextTag getTag() {
        return new TextTag("persons", this);
    }

    @Override
    public float belongsTo(Area node) {
        if (node.isLeaf()) {
            String text = node.getText();
            List list = this.getClassifier().classifyToCharacterOffsets(text);
            int cnt = 0;
            for (Triple t : list) {
                if (((String)t.first()).equals("PERSON")) {
                    ++cnt;
                }
                if (cnt < this.mincnt) continue;
                return 0.8f;
            }
            if (this.checkAllowedFormat(text)) {
                return 0.1f;
            }
        }
        return 0.0f;
    }

    private boolean checkAllowedFormat(String text) {
        int cnt = 0;
        while (this.couldexpr.matcher(text).find()) {
            if (++cnt < this.mincnt) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowsContinuation(Area node) {
        String text;
        return node.isLeaf() && this.contexpr.matcher(text = node.getText().trim()).lookingAt();
    }

    @Override
    public boolean mayCoexistWith(Tag other) {
        return true;
    }

    @Override
    public boolean allowsJoining() {
        return true;
    }

    @Override
    public List<String> extract(String src) {
        Vector<String> ret = new Vector<String>();
        List list = this.getClassifier().classifyToCharacterOffsets(src);
        for (Triple t : list) {
            if (!((String)t.first()).equals("PERSON")) continue;
            ret.add(src.substring((Integer)t.second(), (Integer)t.third()));
        }
        return ret;
    }

    @Override
    public List<String> split(String src) {
        ArrayList<String> ret = new ArrayList<String>(1);
        ret.add(src);
        return ret;
    }
}

