/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify.taggers;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fit.layout.classify.TextTag;
import org.fit.layout.classify.taggers.BaseTagger;
import org.fit.layout.model.Area;
import org.fit.layout.model.Tag;

public class TimeTagger
extends BaseTagger {
    private static final float YES = 0.95f;
    private static final float NO = 0.0f;
    protected Pattern[] timeexpr = new Pattern[]{Pattern.compile("[0-2]?[0-9][:\\.][0-5][0-9]([ap])?m?")};

    public String getId() {
        return "FITLayout.Tag.Time";
    }

    public String getName() {
        return "Times";
    }

    public String getDescription() {
        return "Tags the areas that contain some time expressions";
    }

    @Override
    public TextTag getTag() {
        return new TextTag("time", this);
    }

    @Override
    public float belongsTo(Area node) {
        if (node.isLeaf()) {
            String[] words;
            String text = node.getText();
            for (String s : words = text.split("\\s+")) {
                for (Pattern p : this.timeexpr) {
                    if (!p.matcher(s).lookingAt()) continue;
                    return 0.95f;
                }
            }
        }
        return 0.0f;
    }

    @Override
    public boolean allowsContinuation(Area node) {
        return false;
    }

    @Override
    public boolean allowsJoining() {
        return false;
    }

    @Override
    public boolean mayCoexistWith(Tag other) {
        return true;
    }

    @Override
    public List<String> extract(String src) {
        String[] words;
        Vector<String> ret = new Vector<String>();
        for (String s : words = src.toLowerCase().split("[^0-9:\\.apm]")) {
            for (Pattern p : this.timeexpr) {
                Matcher match = p.matcher(s);
                if (!match.lookingAt()) continue;
                ret.add(match.group());
            }
        }
        return ret;
    }

    @Override
    public List<String> split(String src) {
        ArrayList<String> ret = new ArrayList<String>(1);
        ret.add(src);
        return ret;
    }
}

