/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify;

import java.awt.Color;
import java.util.HashMap;
import org.fit.layout.model.Area;
import org.fit.layout.model.Box;

public class ColorAnalyzer {
    private HashMap<Integer, Integer> colors = new HashMap();
    private Area root;
    private int totalLength;

    public ColorAnalyzer(Area root) {
        this.root = root;
        this.computeRootStatistics(this.root);
        this.totalLength = this.letterLength(this.root.getText());
        System.err.println("We have " + this.colors.size() + " different colors, " + this.totalLength + " total length");
    }

    public double getColorPercentage(Color color) {
        if (color == null) {
            return 0.0;
        }
        Integer num = this.colors.get(this.colorKey(color));
        if (num == null) {
            num = 0;
        }
        if (this.totalLength == 0) {
            return 0.0;
        }
        return (double)num.intValue() / (double)this.totalLength;
    }

    public double getColorPercentage(Area node) {
        int tlen = 0;
        double sum = 0.0;
        for (Box box : node.getBoxes()) {
            int len = this.letterLength(box.getText());
            if (len <= 0) continue;
            sum += this.getColorPercentage(box.getColor()) * (double)len;
            tlen += len;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            Area child = (Area)node.getChildArea(i);
            int nlen = this.letterLength(child.getText());
            tlen += nlen;
            sum += this.getColorPercentage(child) * (double)nlen;
        }
        if (tlen == 0) {
            return 0.0;
        }
        return sum / (double)tlen;
    }

    private void computeRootStatistics(Area root) {
        for (Box box : root.getBoxes()) {
            int len = this.letterLength(box.getText());
            if (len <= 0) continue;
            int key = this.colorKey(box.getColor());
            Integer val = this.colors.get(key);
            if (val == null) {
                val = 0;
            }
            val = val + len;
            this.colors.put(key, val);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.computeRootStatistics((Area)root.getChildArea(i));
        }
    }

    private int letterLength(String s) {
        int len = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (Character.getType(s.charAt(i)) == 12) continue;
            ++len;
        }
        return len;
    }

    private int colorKey(Color color) {
        return color.getRed() / 16 * 256 + color.getGreen() / 16 * 16 + color.getBlue() / 16;
    }
}

