/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify;

import java.io.File;
import java.io.IOException;
import org.fit.layout.classify.FeatureExtractor;
import org.fit.layout.model.Area;
import org.fit.layout.model.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ArffSaver;

public class InstanceExtractor {
    private static Logger log = LoggerFactory.getLogger(InstanceExtractor.class);
    private FeatureExtractor features;
    private String tagType;
    private String defaultClass;
    private Instances data;

    public InstanceExtractor(FeatureExtractor features, String tagType) {
        this.features = features;
        this.tagType = tagType;
        this.data = features.createEmptyDataset();
        this.defaultClass = "none";
    }

    public void setDefaultClass(String defaultClass) {
        this.defaultClass = defaultClass;
    }

    public Instances getData() {
        return this.data;
    }

    public void clear() {
        this.data = this.features.createEmptyDataset();
    }

    public void extractInstances(Area root) {
        this.features.setTree(root);
        this.recursiveExtractInstances(root, this.data);
    }

    public void save(String filename) {
        try {
            ArffSaver saver = new ArffSaver();
            saver.setInstances(this.data);
            saver.setFile(new File(filename));
            saver.writeBatch();
        }
        catch (IOException e) {
            log.error("Couldn't save to " + filename + " : " + e.getMessage());
            e.printStackTrace();
        }
    }

    public int count() {
        return this.data.numInstances();
    }

    protected void recursiveExtractInstances(Area root, Instances dest) {
        Instance newinst = this.features.getAreaFeatures(root, dest);
        String cls = this.defaultClass;
        for (Tag tag : root.getTags().keySet()) {
            if (!tag.getType().equals(this.tagType)) continue;
            cls = tag.getValue();
        }
        newinst.setClassValue(cls);
        dest.add(newinst);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveExtractInstances((Area)root.getChildArea(i), dest);
        }
    }
}

