/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify;

import java.awt.Color;
import java.util.Vector;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTopology;
import org.fit.layout.model.Box;

public class NodeStyle {
    private float fontSize;
    private float style;
    private float weight;
    private Color color;
    private int indent;

    public NodeStyle(Area area) {
        Vector boxes = area.getAllBoxes();
        this.fontSize = area.getFontSize();
        this.style = area.getFontStyle();
        this.weight = area.getFontWeight();
        this.color = !boxes.isEmpty() ? ((Box)boxes.firstElement()).getColor() : Color.BLACK;
        this.indent = (int)Math.round(this.computeIndentation(area));
    }

    public NodeStyle(NodeStyle src) {
        this.fontSize = src.fontSize;
        this.style = src.style;
        this.weight = src.weight;
        this.color = new Color(src.color.getRed(), src.color.getGreen(), src.color.getGreen(), src.color.getAlpha());
        this.indent = src.indent;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public float getStyle() {
        return this.style;
    }

    public float getWeight() {
        return this.weight;
    }

    public Color getColor() {
        return this.color;
    }

    public int getIndent() {
        return this.indent;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + Float.floatToIntBits(this.fontSize);
        result = 31 * result + this.indent;
        result = 31 * result + Float.floatToIntBits(this.style);
        result = 31 * result + Float.floatToIntBits(this.weight);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeStyle other = (NodeStyle)obj;
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        if (Float.floatToIntBits(this.fontSize) != Float.floatToIntBits(other.fontSize)) {
            return false;
        }
        if (this.indent != other.indent) {
            return false;
        }
        if (Float.floatToIntBits(this.style) != Float.floatToIntBits(other.style)) {
            return false;
        }
        return Float.floatToIntBits(this.weight) == Float.floatToIntBits(other.weight);
    }

    public String toString() {
        String ret = "[fs:" + this.fontSize + " w:" + this.weight + " s:" + this.style + " c:";
        ret = ret + String.format("#%02x%02x%02x", this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        ret = ret + " i:" + this.indent;
        ret = ret + "]";
        return ret;
    }

    public String toARFFString() {
        return this.fontSize + "," + this.weight + "," + this.style + "," + (double)this.color.getRed() / 255.0 + "," + (double)this.color.getGreen() / 255.0 + "," + (double)this.color.getBlue() / 255.0 + "," + this.indent;
    }

    private double computeIndentation(Area area) {
        double max_levels = 3.0;
        AreaTopology topo = area.getTopology();
        if (topo.getPreviousOnLine() != null) {
            return this.computeIndentation(topo.getPreviousOnLine());
        }
        double ind = 3.0;
        if (area.getParentArea() != null) {
            ind -= (double)(topo.getPosition().getX1() - ((Area)area.getParentArea()).getTopology().getMinIndent());
        }
        if (ind < 0.0) {
            ind = 0.0;
        }
        return ind / 3.0;
    }
}

