/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class StyleCounter<T> {
    private Map<T, Integer> styles = new HashMap<T, Integer>();

    public void add(T style) {
        Integer cnt = this.styles.get(style);
        if (cnt == null) {
            this.styles.put(style, 1);
        } else {
            this.styles.put(style, cnt + 1);
        }
    }

    public int getCount(T style) {
        Integer cnt = this.styles.get(style);
        return cnt == null ? 0 : cnt;
    }

    public T getMostFrequent() {
        T ret = null;
        int freq = 0;
        for (Map.Entry<T, Integer> entry : this.styles.entrySet()) {
            if (entry.getValue() <= freq) continue;
            ret = entry.getKey();
            freq = entry.getValue();
        }
        return ret;
    }

    public List<T> getMostFrequentAll() {
        Vector<T> ret = new Vector<T>();
        int maxfreq = 0;
        for (Map.Entry<T, Integer> entry : this.styles.entrySet()) {
            if (entry.getValue() <= maxfreq) continue;
            maxfreq = entry.getValue();
        }
        for (Map.Entry<T, Integer> entry : this.styles.entrySet()) {
            if (entry.getValue() != maxfreq) continue;
            ret.add(entry.getKey());
        }
        return ret;
    }

    public Map<T, Integer> getAll() {
        return this.styles;
    }

    public Set<T> getDistinctStyles() {
        return this.styles.keySet();
    }

    public List<T> getFrequentSyles(float factor) {
        ArrayList<T> ret = new ArrayList<T>();
        int maxfreq = 0;
        for (Map.Entry<T, Integer> entry : this.styles.entrySet()) {
            if (entry.getValue() <= maxfreq) continue;
            maxfreq = entry.getValue();
        }
        for (Map.Entry<T, Integer> entry : this.styles.entrySet()) {
            if (!((float)entry.getValue().intValue() >= factor * (float)maxfreq)) continue;
            ret.add(entry.getKey());
        }
        return ret;
    }

    public Map<T, Integer> getAllSorted() {
        Map<T, Integer> map = this.styles;
        TreeMap<T, Integer> smap = new TreeMap<T, Integer>(new StyleCountComparator(map));
        smap.putAll(map);
        return smap;
    }

    public String toString() {
        Map<T, Integer> map = this.getAllSorted();
        StringBuilder ret = new StringBuilder();
        for (Map.Entry<T, Integer> entry : map.entrySet()) {
            ret.append(entry.getValue()).append("x(");
            ret.append(entry.getKey().toString());
            ret.append(") ");
        }
        return ret.toString();
    }

    class StyleCountComparator
    implements Comparator<T> {
        Map<T, Integer> base;

        public StyleCountComparator(Map<T, Integer> base) {
            this.base = base;
        }

        @Override
        public int compare(T a, T b) {
            if (this.base.get(a) >= this.base.get(b)) {
                return -1;
            }
            return 1;
        }
    }
}

