/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.fit.layout.classify.Tagger;
import org.fit.layout.model.Area;
import org.fit.layout.model.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeTagger {
    private static Logger log = LoggerFactory.getLogger(TreeTagger.class);
    private static final float MIN_SUPPORT = 0.01f;
    private static AbstractSequenceClassifier<?> sharedClassifier;
    protected Area root;
    protected Vector<Tagger> taggers;

    public TreeTagger(Area root) {
        this.root = root;
        this.taggers = new Vector();
    }

    public void addTagger(Tagger tagger) {
        this.taggers.add(tagger);
    }

    public List<Tag> getAllTags() {
        Vector<Tag> ret = new Vector<Tag>(this.taggers.size());
        for (Tagger tagger : this.taggers) {
            ret.add((Tag)tagger.getTag());
        }
        return ret;
    }

    public void tagTree() {
        this.tagSubtree(this.root);
    }

    public void tagSubtree(Area root) {
        this.tagSingleNode(root);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.tagSubtree((Area)root.getChildArea(i));
        }
    }

    public void tagSingleNode(Area area) {
        for (Tagger t : this.taggers) {
            float support = t.belongsTo(area);
            if (!(support > 0.01f)) continue;
            area.addTag((Tag)t.getTag(), support);
        }
    }

    public static AbstractSequenceClassifier<?> getSharedClassifier() {
        if (sharedClassifier == null) {
            log.info("Loading resource {}", (Object)TreeTagger.class.getResource("/3class.gz"));
            try {
                GZIPInputStream is = new GZIPInputStream(TreeTagger.class.getResourceAsStream("/3class.gz"));
                sharedClassifier = CRFClassifier.getClassifier((InputStream)is);
            }
            catch (IOException e) {
                System.err.println("Load failed: " + e.getMessage());
            }
            catch (ClassCastException e) {
                System.err.println("Load failed: " + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                System.err.println("Load failed: " + e.getMessage());
            }
        }
        return sharedClassifier;
    }
}

