/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify.articles;

import java.awt.Color;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.fit.layout.classify.BackgroundColorAnalyzer;
import org.fit.layout.classify.ColorAnalyzer;
import org.fit.layout.classify.DefaultFeatureExtractor;
import org.fit.layout.classify.articles.FeatureVector;
import org.fit.layout.model.Area;
import org.fit.layout.model.Box;
import org.fit.layout.model.Rectangular;
import org.fit.layout.model.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class ArticleFeatureExtractor
extends DefaultFeatureExtractor {
    private static Logger log = LoggerFactory.getLogger(ArticleFeatureExtractor.class);
    public static final double MIN_MARKEDNESS_DIFFERENCE = 0.5;
    public static final double[] DEFAULT_WEIGHTS = new double[]{1000.0, 2.0, 0.5, 5.0, 0.0, 1.0, 0.5, 100.0};
    public static final double CENTERING_THRESHOLD = 0.1;
    private static final int WFSZ = 0;
    private static final int WFWT = 1;
    private static final int WFST = 2;
    private static final int WIND = 3;
    private static final int WCON = 4;
    private static final int WCEN = 5;
    private static final int WCP = 6;
    private static final int WBCP = 7;
    private double[] weights = DEFAULT_WEIGHTS;
    private Area root;
    private float avgfont;
    private ColorAnalyzer ca;
    private BackgroundColorAnalyzer bca;

    @Override
    public void setTree(Area rootNode) {
        this.root = rootNode;
        this.avgfont = this.root.getFontSize();
        this.ca = new ColorAnalyzer(this.root);
        this.bca = new BackgroundColorAnalyzer(this.root);
    }

    @Override
    public Area getTreeRoot() {
        return this.root;
    }

    @Override
    public Instances createEmptyDataset() {
        try {
            return this.loadArffDatasetResource("articles_header.arff");
        }
        catch (Exception e) {
            log.error("Couldn't create empty dataset: " + e.getMessage());
            return null;
        }
    }

    @Override
    public Instance getAreaFeatures(Area node, Instances dataset) {
        FeatureVector f = this.getFeatureVector(node);
        DenseInstance inst = new DenseInstance(30);
        inst.setDataset(dataset);
        int i = 0;
        inst.setValue(i++, 0.0);
        inst.setValue(i++, 0.0);
        inst.setValue(i++, f.getFontSize() * 100.0);
        inst.setValue(i++, f.getWeight());
        inst.setValue(i++, f.getStyle());
        inst.setValue(i++, f.isReplaced() ? 1.0 : 0.0);
        inst.setValue(i++, (double)f.getAabove());
        inst.setValue(i++, (double)f.getAbelow());
        inst.setValue(i++, (double)f.getAleft());
        inst.setValue(i++, (double)f.getAright());
        inst.setValue(i++, (double)f.getNlines());
        inst.setValue(i++, 1.0);
        inst.setValue(i++, (double)f.getDepth());
        inst.setValue(i++, (double)f.getTlength());
        inst.setValue(i++, f.getPdigits());
        inst.setValue(i++, f.getPlower());
        inst.setValue(i++, f.getPupper());
        inst.setValue(i++, f.getPspaces());
        inst.setValue(i++, f.getPpunct());
        inst.setValue(i++, f.getRelx());
        inst.setValue(i++, f.getRely());
        inst.setValue(i++, f.getTlum());
        inst.setValue(i++, f.getBglum());
        inst.setValue(i++, f.getContrast());
        inst.setValue(i++, f.getMarkedness());
        inst.setValue(i++, f.getCperc());
        return inst;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public double getMarkedness(Area node) {
        double fsz = node.getFontSize() / this.avgfont;
        double fwt = node.getFontWeight();
        double fst = node.getFontStyle();
        double ind = this.getIndentation(node);
        double cen = this.isCentered(node) ? 1.0 : 0.0;
        double contrast = this.getContrast(node);
        double cp = 1.0 - this.ca.getColorPercentage(node);
        double bcp = this.bca.getColorPercentage(node);
        bcp = bcp < 0.0 ? 0.0 : 1.0 - bcp;
        double exp = this.weights[0] * fsz + this.weights[1] * fwt + this.weights[2] * fst + this.weights[3] * ind + this.weights[4] * contrast + this.weights[5] * cen + this.weights[6] * cp + this.weights[7] * bcp;
        return exp;
    }

    public FeatureVector getFeatureVector(Area node) {
        FeatureVector ret = new FeatureVector();
        String text = node.getText();
        int plen = text.length();
        if (plen == 0) {
            plen = 1;
        }
        ret.setFontSize(node.getFontSize() / this.avgfont);
        ret.setWeight(node.getFontWeight());
        ret.setStyle(node.getFontStyle());
        ret.setReplaced(node.isReplaced());
        ret.setAabove(this.countAreasAbove(node));
        ret.setAbelow(this.countAreasBelow(node));
        ret.setAleft(this.countAreasLeft(node));
        ret.setAright(this.countAreasRight(node));
        ret.setNlines(this.getLineCount(node));
        ret.setDepth(node.getDepth() + 1);
        ret.setTlength(text.length());
        ret.setPdigits((double)this.countChars(text, 9) / (double)plen);
        ret.setPlower((double)this.countChars(text, 2) / (double)plen);
        ret.setPupper((double)this.countChars(text, 1) / (double)plen);
        ret.setPspaces((double)this.countChars(text, 12) / (double)plen);
        ret.setPpunct((double)this.countCharsPunct(text) / (double)plen);
        ret.setRelx(this.getRelX(node));
        ret.setRely(this.getRelY(node));
        ret.setTlum(this.getAverageTextLuminosity(node));
        ret.setBglum(this.getBackgroundLuminosity(node));
        ret.setContrast(this.getContrast(node));
        ret.setCperc(this.ca.getColorPercentage(node));
        ret.setBcperc(this.bca.getColorPercentage(node));
        ret.setMarkedness(this.getMarkedness(node));
        Tag t = node.getMostSupportedTag();
        ret.setTagLevel(t == null ? -1 : t.getLevel());
        return ret;
    }

    public boolean isCentered(Area area) {
        return this.isCentered(area, true, true) == 1;
    }

    private int isCentered(Area area, boolean askBefore, boolean askAfter) {
        Area parent = (Area)area.getParentArea();
        if (parent != null) {
            boolean fullwidth;
            int right;
            int left = area.getX1() - parent.getX1();
            int limit = (int)((double)(left + (right = parent.getX2() - area.getX2())) / 2.0 * 0.1);
            if (limit == 0) {
                limit = 1;
            }
            boolean middle = Math.abs(left - right) <= limit;
            boolean bl = fullwidth = left == 0 && right == 0;
            if (!middle && !fullwidth) {
                return 0;
            }
            Area prev = null;
            Area next = null;
            int pc = 2;
            int nc = 2;
            if (askBefore || askAfter) {
                if (askBefore) {
                    for (prev = (Area)area.getPreviousSibling(); prev != null && (pc = this.isCentered(prev, true, false)) == 2; prev = (Area)prev.getPreviousSibling()) {
                    }
                }
                if (askAfter) {
                    for (next = (Area)area.getNextSibling(); next != null && (nc = this.isCentered(next, false, true)) == 2; next = (Area)next.getNextSibling()) {
                    }
                }
            }
            if (pc != 2 || nc != 2) {
                if (fullwidth) {
                    if (pc != 0 && nc != 0) {
                        return 1;
                    }
                    return 0;
                }
                if (prev != null && this.lrAligned(area, prev) == 1 || next != null && this.lrAligned(area, next) == 1) {
                    return 0;
                }
                return 1;
            }
            if (fullwidth) {
                return 2;
            }
            return middle ? 1 : 0;
        }
        return 2;
    }

    private int lrAligned(Area a1, Area a2) {
        if (a1.getX1() == a2.getX1()) {
            return a1.getX2() == a2.getX2() ? 2 : 1;
        }
        if (a1.getX2() == a2.getX2()) {
            return 1;
        }
        return 0;
    }

    public double getIndentation(Area node) {
        double max_levels = 3.0;
        if (node.getTopology().getPreviousOnLine() != null) {
            return this.getIndentation(node.getTopology().getPreviousOnLine());
        }
        double ind = 3.0;
        if (!this.isCentered(node) && node.getParentArea() != null) {
            ind -= (double)(node.getTopology().getPosition().getX1() - ((Area)node.getParentArea()).getTopology().getMinIndent());
        }
        if (ind < 0.0) {
            ind = 0.0;
        }
        return ind / 3.0;
    }

    private int countAreas(Area a, Rectangular r) {
        int ret = 0;
        for (int i = 0; i < a.getChildCount(); ++i) {
            Area n = (Area)a.getChildArea(i);
            if (!n.getTopology().getPosition().intersects(r)) continue;
            ++ret;
        }
        return ret;
    }

    private int countAreasAbove(Area a) {
        Rectangular gp = a.getTopology().getPosition();
        Area parent = (Area)a.getParentArea();
        if (parent != null) {
            Rectangular r = new Rectangular(gp.getX1(), 0, gp.getX2(), gp.getY1() - 1);
            return this.countAreas(parent, r);
        }
        return 0;
    }

    private int countAreasBelow(Area a) {
        Rectangular gp = a.getTopology().getPosition();
        Area parent = (Area)a.getParentArea();
        if (parent != null) {
            Rectangular r = new Rectangular(gp.getX1(), gp.getY2() + 1, gp.getX2(), Integer.MAX_VALUE);
            return this.countAreas(parent, r);
        }
        return 0;
    }

    private int countAreasLeft(Area a) {
        Rectangular gp = a.getTopology().getPosition();
        Area parent = (Area)a.getParentArea();
        if (parent != null) {
            Rectangular r = new Rectangular(0, gp.getY1(), gp.getX1() - 1, gp.getY2());
            return this.countAreas(parent, r);
        }
        return 0;
    }

    private int countAreasRight(Area a) {
        Rectangular gp = a.getTopology().getPosition();
        Area parent = (Area)a.getParentArea();
        if (parent != null) {
            Rectangular r = new Rectangular(gp.getX2() + 1, gp.getY1(), Integer.MAX_VALUE, gp.getY2());
            return this.countAreas(parent, r);
        }
        return 0;
    }

    private int countChars(String s, int type) {
        int ret = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (Character.getType(s.charAt(i)) != type) continue;
            ++ret;
        }
        return ret;
    }

    private int countCharsPunct(String s) {
        int ret = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != ',' && ch != '.' && ch != ';' && ch != ':') continue;
            ++ret;
        }
        return ret;
    }

    private double getAverageTextLuminosity(Area a) {
        double sum = 0.0;
        int cnt = 0;
        if (!a.getBoxes().isEmpty()) {
            int l = a.getText().length();
            sum += this.getAverageBoxColorLuminosity(a) * (double)l;
            cnt += l;
        }
        for (int i = 0; i < a.getChildCount(); ++i) {
            int l = ((Area)a.getChildArea(i)).getText().length();
            sum += this.getAverageTextLuminosity((Area)a.getChildArea(i)) * (double)l;
            cnt += l;
        }
        if (cnt > 0) {
            return sum / (double)cnt;
        }
        return 0.0;
    }

    public double getAverageBoxColorLuminosity(Area area) {
        if (area.getBoxes().isEmpty()) {
            return 0.0;
        }
        double sum = 0.0;
        int len = 0;
        for (Box box : area.getBoxes()) {
            int l = box.getText().length();
            sum += ArticleFeatureExtractor.colorLuminosity(box.getColor()) * (double)l;
            len += l;
        }
        return sum / (double)len;
    }

    private double getBackgroundLuminosity(Area a) {
        Color bg = a.getEffectiveBackgroundColor();
        if (bg != null) {
            return ArticleFeatureExtractor.colorLuminosity(bg);
        }
        return 0.0;
    }

    private double getContrast(Area a) {
        double tb;
        double bb = this.getBackgroundLuminosity(a);
        double lum = bb > (tb = this.getAverageTextLuminosity(a)) ? (bb + 0.05) / (tb + 0.05) : (tb + 0.05) / (bb + 0.05);
        return lum;
    }

    public static double colorLuminosity(Color c) {
        double lr;
        double lg;
        double lb;
        if (c == null) {
            lb = 255.0;
            lg = 255.0;
            lr = 255.0;
        } else {
            lr = Math.pow((double)c.getRed() / 255.0, 2.2);
            lg = Math.pow((double)c.getGreen() / 255.0, 2.2);
            lb = Math.pow((double)c.getBlue() / 255.0, 2.2);
        }
        return lr * 0.2126 + lg * 0.7152 + lb * 0.0722;
    }

    private double getRelX(Area a) {
        int topx2;
        int topx1;
        int objx2;
        int objx1 = a.getX1();
        if (objx1 < 0) {
            objx1 = 0;
        }
        if ((objx2 = a.getX2()) < 0) {
            objx2 = 0;
        }
        if ((topx1 = this.root.getX1()) < 0) {
            topx1 = 0;
        }
        if ((topx2 = this.root.getX2()) < 0) {
            topx2 = 0;
        }
        double midw = (double)(objx2 - objx1) / 2.0;
        double topx = (double)topx1 + midw;
        double midx = (double)(objx1 + objx2) / 2.0 - topx;
        double topw = topx2 - topx1 - (objx2 - objx1);
        return midx / topw;
    }

    public double getRelY(Area a) {
        int topy2;
        int topy1;
        int objy2;
        int objy1 = a.getY1();
        if (objy1 < 0) {
            objy1 = 0;
        }
        if ((objy2 = a.getY2()) < 0) {
            objy2 = 0;
        }
        if ((topy1 = this.root.getY1()) < 0) {
            topy1 = 0;
        }
        if ((topy2 = this.root.getY2()) < 0) {
            topy2 = 0;
        }
        double midh = (double)(objy2 - objy1) / 2.0;
        double topy = (double)topy1 + midh;
        double midy = (double)(objy1 + objy2) / 2.0 - topy;
        double toph = topy2 - topy1 - (objy2 - objy1);
        return midy / toph;
    }

    public int getLineCount(Area a) {
        int LINE_THRESHOLD = 5;
        Vector leaves = a.getAllBoxes();
        Collections.sort(leaves, new AbsoluteYPositionComparator());
        int lines = 0;
        int lastpos = -10;
        for (Box leaf : leaves) {
            int pos = leaf.getBounds().getY1();
            if (pos - lastpos <= 5) continue;
            ++lines;
            lastpos = pos;
        }
        return lines;
    }

    protected Set<Tag> getAllTags(Area area) {
        HashSet<Tag> ret = new HashSet<Tag>(area.getTags().keySet());
        for (int i = 0; i < area.getChildCount(); ++i) {
            ret.addAll(((Area)area.getChildArea(i)).getTags().keySet());
        }
        return ret;
    }

    class AbsoluteYPositionComparator
    implements Comparator<Box> {
        AbsoluteYPositionComparator() {
        }

        @Override
        public int compare(Box o1, Box o2) {
            return o1.getBounds().getY1() - o2.getBounds().getY1();
        }
    }

    class AbsoluteXPositionComparator
    implements Comparator<Box> {
        AbsoluteXPositionComparator() {
        }

        @Override
        public int compare(Box o1, Box o2) {
            return o1.getBounds().getX1() - o2.getBounds().getX1();
        }
    }
}

