/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.fit.layout.api.AreaTreeOperator;
import org.fit.layout.api.ServiceManager;
import org.fit.layout.classify.FeatureExtractor;
import org.fit.layout.classify.op.VisualClassificationOperator;
import org.fit.layout.gui.AreaSelectionListener;
import org.fit.layout.gui.Browser;
import org.fit.layout.gui.BrowserPlugin;
import org.fit.layout.model.Area;
import org.fit.layout.model.Tag;
import weka.core.Instance;
import weka.core.Instances;

public class ClassificationPlugin
implements BrowserPlugin,
AreaSelectionListener {
    private Browser browser;
    private FeatureExtractor features;
    private Instances dataset;
    private JToolBar toolbar;
    private JButton tagsButton;
    private JButton classesButton;
    private JScrollPane featuresScroll;
    private JTable featuresTable;

    public boolean init(Browser browser) {
        this.browser = browser;
        this.browser.addToolBar(this.getToolbar());
        this.browser.addInfoPanel((JComponent)this.getFeaturesScroll(), 0.5);
        this.browser.addAreaSelectionListener((AreaSelectionListener)this);
        return true;
    }

    public FeatureExtractor getFeatureExtractor() {
        AreaTreeOperator vcls;
        if (this.features == null && (vcls = (AreaTreeOperator)ServiceManager.findAreaTreeOperators().get("FitLayout.Tag.Visual")) != null && vcls instanceof VisualClassificationOperator) {
            this.features = ((VisualClassificationOperator)vcls).getFeatures();
            this.dataset = this.features.createEmptyDataset();
        }
        return this.features;
    }

    private JToolBar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar("Classification");
            this.toolbar.add(this.getTagsButton());
            this.toolbar.add(this.getClassesButton());
        }
        return this.toolbar;
    }

    private JButton getTagsButton() {
        if (this.tagsButton == null) {
            this.tagsButton = new JButton("Tags");
            this.tagsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Area node = ClassificationPlugin.this.browser.getSelectedArea();
                    if (node != null) {
                        ClassificationPlugin.this.colorizeTags(node, "FitLayout.TextTag");
                    }
                }
            });
        }
        return this.tagsButton;
    }

    private JButton getClassesButton() {
        if (this.classesButton == null) {
            this.classesButton = new JButton("Classes");
            this.classesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Area node = ClassificationPlugin.this.browser.getSelectedArea();
                    if (node != null) {
                        ClassificationPlugin.this.colorizeTags(node, "FitLayout.VisualTag");
                    }
                }
            });
        }
        return this.classesButton;
    }

    private JScrollPane getFeaturesScroll() {
        if (this.featuresScroll == null) {
            this.featuresScroll = new JScrollPane();
            this.featuresScroll.setViewportView(this.getFeaturesTable());
        }
        return this.featuresScroll;
    }

    private JTable getFeaturesTable() {
        if (this.featuresTable == null) {
            this.featuresTable = new JTable();
        }
        return this.featuresTable;
    }

    private void colorizeTags(Area root, String type) {
        this.recursiveColorizeTags(root, type);
        this.browser.updateDisplay();
    }

    private void recursiveColorizeTags(Area root, String type) {
        HashSet<Tag> tags = new HashSet<Tag>();
        for (Tag tag : root.getSupportedTags(0.3f)) {
            if (!tag.getType().equals(type)) continue;
            tags.add(tag);
        }
        this.browser.getOutputDisplay().colorizeByTags(root, tags);
        for (Area child : root.getChildAreas()) {
            this.recursiveColorizeTags(child, type);
        }
    }

    public void areaSelected(Area area) {
        if (area != null) {
            FeatureExtractor fe = this.getFeatureExtractor();
            if (fe.getTreeRoot() == null) {
                fe.setTree(this.browser.getAreaTree().getRoot());
            }
            Instance data = this.getFeatureExtractor().getAreaFeatures(area, this.dataset);
            Vector<Vector<String>> fvals = new Vector<Vector<String>>();
            for (int i = 0; i < data.numAttributes(); ++i) {
                String name = data.attribute(i).name();
                String value = data.attribute(i).isNumeric() ? String.valueOf(data.value(i)) : data.stringValue(i);
                fvals.add(this.infoTableData(name, value));
            }
            this.getFeaturesTable().setModel(new DefaultTableModel(fvals, this.infoTableData("Property", "Value")));
        } else {
            TableModel model = this.getFeaturesTable().getModel();
            if (model != null && model instanceof DefaultTableModel) {
                ((DefaultTableModel)model).setRowCount(0);
            }
        }
    }

    private Vector<String> infoTableData(String prop, String value) {
        Vector<String> cols = new Vector<String>(2);
        cols.add(prop);
        cols.add(value);
        return cols;
    }
}

