/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify.op;

import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.api.ScriptObject;
import org.fit.layout.api.ServiceManager;
import org.fit.layout.classify.Tagger;
import org.fit.layout.classify.TreeTagger;
import org.fit.layout.impl.BaseOperator;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;

public class TagEntitiesOperator
extends BaseOperator
implements ScriptObject {
    private TreeTagger tagger;
    private Map<String, Tagger> availableTaggers;
    private List<Tagger> usedTaggers;

    public TagEntitiesOperator() {
        this.initTaggers();
    }

    public String getId() {
        return "FitLayout.Tag.Entities";
    }

    public String getName() {
        return "Tag entities";
    }

    public String getDescription() {
        return "Recognizes entities in area text using different taggersand adds the corresponding tags to the areas.";
    }

    public String getCategory() {
        return "classification";
    }

    public void addTagger(Tagger tagger) {
        this.usedTaggers.add(tagger);
    }

    public void clearTaggers() {
        this.usedTaggers.clear();
    }

    public Tagger findTagger(String id, Map<String, Object> params) {
        ParametrizedOperation op = this.availableTaggers.get(id);
        if (op != null) {
            ServiceManager.setServiceParams((ParametrizedOperation)op, params);
        }
        return (Tagger)op;
    }

    protected void initTaggers() {
        this.availableTaggers = ServiceManager.loadServicesByType(Tagger.class);
        this.usedTaggers = new ArrayList<Tagger>(this.availableTaggers.values());
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        this.tagger = new TreeTagger(root);
        for (Tagger t : this.usedTaggers) {
            this.tagger.addTagger(t);
        }
        this.tagger.tagTree();
    }

    public String getVarName() {
        return "entities";
    }

    public void setIO(Reader in, Writer out, Writer err) {
    }
}

