/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify.op;

import java.util.ArrayList;
import java.util.List;
import org.fit.layout.api.Parameter;
import org.fit.layout.classify.FeatureExtractor;
import org.fit.layout.classify.VisualClassifier;
import org.fit.layout.classify.VisualTag;
import org.fit.layout.classify.articles.ArticleFeatureExtractor;
import org.fit.layout.impl.BaseOperator;
import org.fit.layout.impl.ParameterBoolean;
import org.fit.layout.impl.ParameterInt;
import org.fit.layout.impl.ParameterString;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Tag;

public class VisualClassificationOperator
extends BaseOperator {
    private String trainFile;
    private int classIndex;
    private boolean classDistribution;
    private FeatureExtractor features;
    private VisualClassifier vcls;

    public VisualClassificationOperator() {
        this.features = new ArticleFeatureExtractor();
        this.classDistribution = false;
    }

    public VisualClassificationOperator(String trainFile, int classIndex, boolean classDistribution) {
        this.trainFile = trainFile;
        this.classIndex = classIndex;
        this.classDistribution = classDistribution;
    }

    public String getId() {
        return "FitLayout.Tag.Visual";
    }

    public String getName() {
        return "Tag visual classes";
    }

    public String getDescription() {
        return "Adds tags to the visual areas based on the result of classification by a selected pre-trained classifier.";
    }

    public String getCategory() {
        return "classification";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>();
        ret.add((Parameter)new ParameterString("trainFile"));
        ret.add((Parameter)new ParameterInt("classIndex"));
        ret.add((Parameter)new ParameterBoolean("classDistribution"));
        return ret;
    }

    public String getTrainFile() {
        return this.trainFile;
    }

    public void setTrainFile(String trainFile) {
        this.trainFile = trainFile;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public void setClassIndex(int classIndex) {
        this.classIndex = classIndex;
    }

    public boolean getClassDistribution() {
        return this.classDistribution;
    }

    public void setClassDistribution(boolean classDistribution) {
        this.classDistribution = classDistribution;
    }

    public FeatureExtractor getFeatures() {
        return this.features;
    }

    public void setFeatures(FeatureExtractor features) {
        this.features = features;
    }

    public VisualClassifier getVisualClassifier() {
        return this.vcls;
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        this.features.setTree(root);
        System.out.println("SETTING ROOT");
        this.vcls = new VisualClassifier(this.trainFile, this.classIndex);
        this.vcls.classifyTree(root, this.features);
        this.recursivelyAddTags(root);
    }

    private void recursivelyAddTags(Area root) {
        if (!this.classDistribution) {
            String cls = this.vcls.classifyArea(root);
            if (cls != null && !cls.isEmpty() && !cls.equals("none")) {
                VisualTag tag = new VisualTag(cls);
                root.addTag((Tag)tag, 0.9f);
            }
        } else {
            double[] dist = this.vcls.distributionForArea(root);
            if (dist != null) {
                for (int i = 0; i < dist.length; ++i) {
                    String cname;
                    if (!(dist[i] >= (double)0.1f) || (cname = this.vcls.getClassName(i)).equals("none")) continue;
                    VisualTag tag = new VisualTag(cname);
                    root.addTag((Tag)tag, (float)dist[i]);
                }
            }
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursivelyAddTags((Area)root.getChildArea(i));
        }
    }
}

