/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.classify.taggers;

import edu.stanford.nlp.util.Triple;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.fit.layout.api.Parameter;
import org.fit.layout.classify.TextTag;
import org.fit.layout.classify.taggers.NERTagger;
import org.fit.layout.impl.ParameterInt;
import org.fit.layout.model.Area;
import org.fit.layout.model.Tag;

public class LocationsTagger
extends NERTagger {
    private static final float YES = 0.8f;
    private static final float NO = 0.0f;
    private int mincnt;

    public LocationsTagger() {
        this.mincnt = 1;
    }

    public LocationsTagger(int mincnt) {
        this.mincnt = mincnt;
    }

    public String getId() {
        return "FITLayout.Tag.Location";
    }

    public String getName() {
        return "Locations";
    }

    public String getDescription() {
        return "NER-based location name area tagger. It tags the areas that contain at least the specified number of location names";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(1);
        ret.add((Parameter)new ParameterInt("mincnt"));
        return ret;
    }

    public int getMincnt() {
        return this.mincnt;
    }

    public void setMincnt(int mincnt) {
        this.mincnt = mincnt;
    }

    @Override
    public TextTag getTag() {
        return new TextTag("locations", this);
    }

    @Override
    public float belongsTo(Area node) {
        if (node.isLeaf()) {
            String text = node.getText();
            List list = this.getClassifier().classifyToCharacterOffsets(text);
            int cnt = 0;
            for (Triple t : list) {
                if (((String)t.first()).equals("LOCATION")) {
                    ++cnt;
                }
                if (cnt < this.mincnt) continue;
                return 0.8f;
            }
        }
        return 0.0f;
    }

    @Override
    public boolean allowsContinuation(Area node) {
        return false;
    }

    @Override
    public boolean allowsJoining() {
        return true;
    }

    @Override
    public boolean mayCoexistWith(Tag other) {
        return true;
    }

    @Override
    public List<String> extract(String src) {
        Vector<String> ret = new Vector<String>();
        List list = this.getClassifier().classifyToCharacterOffsets(src);
        for (Triple t : list) {
            if (!((String)t.first()).equals("LOCATION")) continue;
            ret.add(src.substring((Integer)t.second(), (Integer)t.third()));
        }
        return ret;
    }

    @Override
    public List<String> split(String src) {
        ArrayList<String> ret = new ArrayList<String>(1);
        ret.add(src);
        return ret;
    }
}

