/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.cssbox;

import cz.vutbr.web.css.CSSProperty;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Vector;
import org.fit.cssbox.layout.BlockReplacedBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.InlineReplacedBox;
import org.fit.cssbox.layout.ListItemBox;
import org.fit.cssbox.layout.ReplacedBox;
import org.fit.cssbox.layout.ReplacedContent;
import org.fit.cssbox.layout.ReplacedImage;
import org.fit.cssbox.layout.TextBox;
import org.fit.cssbox.layout.Viewport;
import org.fit.layout.cssbox.ContentImageImpl;
import org.fit.layout.impl.GenericTreeNode;
import org.fit.layout.model.Box;
import org.fit.layout.model.ContentObject;
import org.fit.layout.model.Page;
import org.fit.layout.model.Rectangular;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BoxNode
extends GenericTreeNode
implements org.fit.layout.model.Box {
    private static final int OVERLAP = 2;
    private static final double AREAP = 0.9;
    protected Box box;
    protected Page page;
    protected int order;
    protected Rectangular bounds;
    protected Rectangular content;
    protected Rectangular visual = null;
    protected boolean backgroundSeparated = false;
    protected Color efficientBackground = null;
    public BoxNode nearestParent = null;

    public BoxNode(Box box, Page page) {
        this.box = box;
        this.page = page;
        if (box != null) {
            this.content = this.computeContentBounds();
            this.bounds = new Rectangular(this.content);
        }
    }

    public int getId() {
        return this.getOrder();
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isRootNode() {
        return this.nearestParent == null;
    }

    public String toString() {
        Box box = this.getBox();
        String ret = "";
        if (this.efficientBackground != null) {
            ret = ret + (box != null && this.isVisuallySeparated() ? "+" : "-");
        }
        ret = ret + this.order + ": ";
        if (box == null) {
            ret = ret + "- empty -";
        } else if (box instanceof Viewport) {
            ret = ret + box.toString();
        } else if (box instanceof ElementBox) {
            ElementBox elem = (ElementBox)box;
            ret = ret + elem.getElement().getTagName();
            ret = ret + " [" + elem.getElement().getAttribute("id") + "]";
            ret = ret + " [" + elem.getElement().getAttribute("class") + "]";
            ret = ret + " B" + this.getBounds().toString();
            ret = ret + " V" + this.getVisualBounds().toString();
        } else if (box instanceof TextBox) {
            ret = ((TextBox)box).getText();
            ret = ret + " (" + box.getAbsoluteBounds().x + "," + box.getAbsoluteBounds().y + "," + (box.getAbsoluteBounds().x + box.getAbsoluteBounds().width - 1) + "," + (box.getAbsoluteBounds().y + box.getAbsoluteBounds().height - 1) + ")";
        } else {
            ret = "?: " + box.toString();
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BoxNode) {
            return ((BoxNode)((Object)obj)).getBox() == this.getBox();
        }
        return false;
    }

    public boolean isBackgroundSeparated() {
        return this.backgroundSeparated;
    }

    public void setBackgroundSeparated(boolean backgroundSeparated) {
        this.backgroundSeparated = backgroundSeparated;
    }

    public Color getEfficientBackground() {
        return this.efficientBackground;
    }

    public void setEfficientBackground(Color bgcolor) {
        this.efficientBackground = bgcolor;
    }

    public boolean isVisuallySeparated() {
        Box box = this.getBox();
        if (!this.isVisible()) {
            return false;
        }
        if (box instanceof Viewport) {
            return true;
        }
        if (box instanceof TextBox) {
            return !box.isEmpty();
        }
        if (box instanceof InlineReplacedBox || box instanceof BlockReplacedBox) {
            return true;
        }
        if (box instanceof ListItemBox) {
            return ((ListItemBox)box).hasVisibleBullet();
        }
        if (this.getBorderCount() >= 1) {
            return true;
        }
        return this.isBackgroundSeparated();
    }

    private Rectangular getMinimalVisualBounds() {
        Box box = this.getBox();
        if (box instanceof TextBox) {
            return new Rectangular(box.getAbsoluteBounds().intersection(box.getClipBlock().getClippedContentBounds()));
        }
        if (box != null && box.isReplaced()) {
            return new Rectangular(box.getMinimalAbsoluteBounds().intersection(box.getClipBlock().getClippedContentBounds()));
        }
        Rectangular ret = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            BoxNode subnode = this.getChildBox(i);
            Box sub = subnode.getBox();
            Rectangular sb = subnode.getMinimalVisualBounds();
            if (!sub.isDisplayed() || !subnode.isVisible() || sb.getWidth() <= 0 || sb.getHeight() <= 0) continue;
            if (ret == null) {
                ret = new Rectangular(sb);
                continue;
            }
            ret.expandToEnclose(sb);
        }
        if (ret == null) {
            Rectangle b = box.getAbsoluteBounds().intersection(box.getClipBlock().getClippedContentBounds());
            return new Rectangular(b.x, b.y, b.x, b.y);
        }
        return ret;
    }

    public Rectangular getVisualBounds() {
        if (this.visual == null) {
            this.visual = this.computeVisualBounds();
        }
        return this.visual;
    }

    private Rectangular computeVisualBounds() {
        Box box = this.getBox();
        Rectangular ret = null;
        if (box instanceof Viewport) {
            ret = new Rectangular(((Viewport)box).getClippedBounds());
        } else if (box instanceof ElementBox) {
            ElementBox elem = (ElementBox)box;
            if (this.getBorderCount() == 1 && !this.isBackgroundSeparated()) {
                Rectangular b = new Rectangular(elem.getAbsoluteBorderBounds().intersection(elem.getClipBlock().getClippedContentBounds()));
                if (this.hasTopBorder()) {
                    ret = new Rectangular(b.getX1(), b.getY1(), b.getX2(), b.getY1() + elem.getBorder().top - 1);
                } else if (this.hasBottomBorder()) {
                    ret = new Rectangular(b.getX1(), b.getY2() - elem.getBorder().bottom + 1, b.getX2(), b.getY2());
                } else if (this.hasLeftBorder()) {
                    ret = new Rectangular(b.getX1(), b.getY1(), b.getX1() + elem.getBorder().left - 1, b.getY2());
                } else if (this.hasRightBorder()) {
                    return new Rectangular(b.getX2() - elem.getBorder().right + 1, b.getY1(), b.getX2(), b.getY2());
                }
            } else {
                ret = this.getBorderCount() >= 2 || this.getBorderCount() == 1 && this.isBackgroundSeparated() ? new Rectangular(elem.getAbsoluteBorderBounds().intersection(elem.getClipBlock().getClippedContentBounds())) : (this.isBackgroundSeparated() ? new Rectangular(elem.getAbsoluteBackgroundBounds().intersection(elem.getClipBlock().getClippedContentBounds())) : this.getMinimalVisualBounds());
            }
        } else {
            ret = this.getMinimalVisualBounds();
        }
        return ret;
    }

    public void recomputeVisualBounds() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildBox(i).recomputeVisualBounds();
        }
        this.visual = this.computeVisualBounds();
    }

    public void recomputeBounds() {
        this.bounds = new Rectangular(this.visual);
        for (int i = 0; i < this.getChildCount(); ++i) {
            BoxNode child = this.getChildBox(i);
            child.recomputeBounds();
            this.expandToEnclose(child);
        }
    }

    private Rectangular computeContentBounds() {
        Box box = this.getBox();
        Rectangular ret = null;
        if (box instanceof ElementBox) {
            ElementBox elem = (ElementBox)box;
            ret = elem.getBorder().top > 0 || elem.getBorder().left > 0 || elem.getBorder().bottom > 0 || elem.getBorder().right > 0 ? new Rectangular(elem.getAbsoluteBorderBounds()) : new Rectangular(elem.getAbsoluteBackgroundBounds());
        } else {
            ret = new Rectangular(box.getAbsoluteBounds());
        }
        if (box.getClipBlock() != null) {
            Rectangular clip = new Rectangular(box.getClipBlock().getClippedContentBounds());
            ret = ret.intersection(clip);
        }
        return ret;
    }

    public int getBorderCount() {
        int bcnt = 0;
        if (this.hasTopBorder()) {
            ++bcnt;
        }
        if (this.hasBottomBorder()) {
            ++bcnt;
        }
        if (this.hasLeftBorder()) {
            ++bcnt;
        }
        if (this.hasRightBorder()) {
            ++bcnt;
        }
        return bcnt;
    }

    public boolean hasTopBorder() {
        Box box = this.getBox();
        return box instanceof ElementBox && ((ElementBox)box).getBorder().top > 0;
    }

    public int getTopBorder() {
        Box box = this.getBox();
        if (box instanceof ElementBox) {
            return ((ElementBox)box).getBorder().top;
        }
        return 0;
    }

    public boolean hasBottomBorder() {
        Box box = this.getBox();
        return box instanceof ElementBox && ((ElementBox)box).getBorder().bottom > 0;
    }

    public int getBottomBorder() {
        Box box = this.getBox();
        if (box instanceof ElementBox) {
            return ((ElementBox)box).getBorder().bottom;
        }
        return 0;
    }

    public boolean hasLeftBorder() {
        Box box = this.getBox();
        return box instanceof ElementBox && ((ElementBox)box).getBorder().left > 0;
    }

    public int getLeftBorder() {
        Box box = this.getBox();
        if (box instanceof ElementBox) {
            return ((ElementBox)box).getBorder().left;
        }
        return 0;
    }

    public boolean hasRightBorder() {
        Box box = this.getBox();
        return box instanceof ElementBox && ((ElementBox)box).getBorder().right > 0;
    }

    public int getRightBorder() {
        Box box = this.getBox();
        if (box instanceof ElementBox) {
            return ((ElementBox)box).getBorder().right;
        }
        return 0;
    }

    public String getEfficientColor() {
        Box box = this.getBox();
        do {
            String color;
            if (!(box instanceof ElementBox) || (color = ((ElementBox)box).getStylePropertyValue("color")).equals("")) continue;
            return color;
        } while ((box = box.getParent()) != null);
        return "";
    }

    public Color getStartColor() {
        return this.getBox().getVisualContext().getColor();
    }

    public boolean containsVisibleTextString() {
        String s = this.getText();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (Character.isSpaceChar(ch)) continue;
            return true;
        }
        return false;
    }

    public boolean isVisible() {
        Box box = this.getBox();
        if (box == null) {
            return false;
        }
        if (box instanceof TextBox) {
            return box.isVisible() && this.containsVisibleTextString() && !this.getEfficientBackground().equals(this.getEfficientColor());
        }
        return box.isVisible();
    }

    public Color getBackgroundColor() {
        if (this.getBox() instanceof ElementBox) {
            return ((ElementBox)this.getBox()).getBgcolor();
        }
        return null;
    }

    public Box getBox() {
        return this.box;
    }

    public BoxNode getParentBox() {
        return (BoxNode)this.getParent();
    }

    public BoxNode getChildBox(int index) {
        return (BoxNode)this.getChildAt(index);
    }

    public Rectangular getBounds() {
        return this.bounds;
    }

    public Rectangular getContentBounds() {
        return this.content;
    }

    public boolean visuallyEncloses(BoxNode childNode) {
        int cx1 = childNode.getVisualBounds().getX1();
        int cy1 = childNode.getVisualBounds().getY1();
        int cx2 = childNode.getVisualBounds().getX2();
        int cy2 = childNode.getVisualBounds().getY2();
        int px1 = this.getVisualBounds().getX1();
        int py1 = this.getVisualBounds().getY1();
        int px2 = this.getVisualBounds().getX2();
        int py2 = this.getVisualBounds().getY2();
        int ccnt = 0;
        if (cx1 >= px1 + 2 && cx1 <= px2 - 2 && cy1 >= py1 + 2 && cy1 <= py2 - 2) {
            ++ccnt;
        }
        if (cx2 >= px1 + 2 && cx2 <= px2 - 2 && cy1 >= py1 + 2 && cy1 <= py2 - 2) {
            ++ccnt;
        }
        if (cx1 >= px1 + 2 && cx1 <= px2 - 2 && cy2 >= py1 + 2 && cy2 <= py2 - 2) {
            ++ccnt;
        }
        if (cx2 >= px1 + 2 && cx2 <= px2 - 2 && cy2 >= py1 + 2 && cy2 <= py2 - 2) {
            ++ccnt;
        }
        int xcnt = 0;
        if (cx1 >= px1 && cx1 <= px2 && cy1 >= py1 && cy1 <= py2) {
            ++xcnt;
        }
        if (cx2 >= px1 && cx2 <= px2 && cy1 >= py1 && cy1 <= py2) {
            ++xcnt;
        }
        if (cx1 >= px1 && cx1 <= px2 && cy2 >= py1 && cy2 <= py2) {
            ++xcnt;
        }
        if (cx2 >= px1 && cx2 <= px2 && cy2 >= py1 && cy2 <= py2) {
            ++xcnt;
        }
        int rxcnt = 0;
        if (px1 >= cx1 && px1 <= cx2 && py1 >= cy1 && py1 <= cy2) {
            ++rxcnt;
        }
        if (px2 >= cx1 && px2 <= cx2 && py1 >= cy1 && py1 <= cy2) {
            ++rxcnt;
        }
        if (px1 >= cx1 && px1 <= cx2 && py2 >= cy1 && py2 <= cy2) {
            ++rxcnt;
        }
        if (px2 >= cx1 && px2 <= cx2 && py2 >= cy1 && py2 <= cy2) {
            ++rxcnt;
        }
        int shared = this.getVisualBounds().intersection(childNode.getVisualBounds()).getArea();
        double sharedperc = (double)shared / (double)childNode.getBounds().getArea();
        if (xcnt == 0) {
            return false;
        }
        if (cx1 == px1 && cy1 == py1 && cx2 == px2 && cy2 == py2 || ccnt == 1 && xcnt <= 1) {
            return this.getOrder() < childNode.getOrder() && sharedperc >= 0.9;
        }
        if (xcnt == 4) {
            return true;
        }
        if (xcnt >= 2) {
            if (rxcnt == 4) {
                return false;
            }
            return this.getOrder() < childNode.getOrder() && sharedperc >= 0.9;
        }
        return false;
    }

    public boolean visuallyEncloses1(BoxNode childNode) {
        int cx1 = childNode.getVisualBounds().getX1();
        int cy1 = childNode.getVisualBounds().getY1();
        int cx2 = childNode.getVisualBounds().getX2();
        int cy2 = childNode.getVisualBounds().getY2();
        int px1 = this.getVisualBounds().getX1();
        int py1 = this.getVisualBounds().getY1();
        int px2 = this.getVisualBounds().getX2();
        int py2 = this.getVisualBounds().getY2();
        int xcnt = 0;
        if (cx1 >= px1 && cx1 <= px2 && cy1 >= py1 && cy1 <= py2) {
            ++xcnt;
        }
        if (cx2 >= px1 && cx2 <= px2 && cy1 >= py1 && cy1 <= py2) {
            ++xcnt;
        }
        if (cx1 >= px1 && cx1 <= px2 && cy2 >= py1 && cy2 <= py2) {
            ++xcnt;
        }
        if (cx2 >= px1 && cx2 <= px2 && cy2 >= py1 && cy2 <= py2) {
            ++xcnt;
        }
        if (cx1 == px1 && cy1 == py1 && cx2 == px2 && cy2 == py2) {
            return this.getOrder() < childNode.getOrder();
        }
        return xcnt == 4;
    }

    public boolean contentEncloses(BoxNode childNode) {
        int cx1 = childNode.getContentBounds().getX1();
        int cy1 = childNode.getContentBounds().getY1();
        int cx2 = childNode.getContentBounds().getX2();
        int cy2 = childNode.getContentBounds().getY2();
        int px1 = this.getContentBounds().getX1();
        int py1 = this.getContentBounds().getY1();
        int px2 = this.getContentBounds().getX2();
        int py2 = this.getContentBounds().getY2();
        int xcnt = 0;
        if (cx1 >= px1 && cx1 <= px2 && cy1 >= py1 && cy1 <= py2) {
            ++xcnt;
        }
        if (cx2 >= px1 && cx2 <= px2 && cy1 >= py1 && cy1 <= py2) {
            ++xcnt;
        }
        if (cx1 >= px1 && cx1 <= px2 && cy2 >= py1 && cy2 <= py2) {
            ++xcnt;
        }
        if (cx2 >= px1 && cx2 <= px2 && cy2 >= py1 && cy2 <= py2) {
            ++xcnt;
        }
        if (cx1 == px1 && cy1 == py1 && cx2 == px2 && cy2 == py2) {
            return this.getOrder() < childNode.getOrder();
        }
        return xcnt == 4;
    }

    public void expandToEnclose(BoxNode child) {
        this.bounds.expandToEnclose(child.getBounds());
    }

    public void markNodesInside(Vector<BoxNode> list, boolean full) {
        for (BoxNode node : list) {
            if (full) {
                if (node == this || !this.contentEncloses(node) || !node.isRootNode() && this.contentEncloses(node.nearestParent)) continue;
                node.nearestParent = this;
                continue;
            }
            if (node == this || !this.visuallyEncloses(node) || !node.isRootNode() && this.visuallyEncloses(node.nearestParent)) continue;
            node.nearestParent = this;
        }
    }

    public void takeChildren(Vector<BoxNode> list) {
        Iterator<BoxNode> it = list.iterator();
        while (it.hasNext()) {
            BoxNode node = it.next();
            if (!node.nearestParent.equals((Object)this)) continue;
            this.add(node);
            it.remove();
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildBox(i).takeChildren(list);
        }
    }

    public void removeFromTree() {
        this.nearestParent = null;
        this.removeAllChildren();
    }

    public String getText() {
        return this.recursiveGetText(this);
    }

    private String recursiveGetText(BoxNode root) {
        Box box = root.getBox();
        if (box instanceof TextBox) {
            return ((TextBox)box).getText();
        }
        String ret = "";
        for (int i = 0; i < root.getChildCount(); ++i) {
            if (ret.trim().length() > 0) {
                ret = ret + " ";
            }
            ret = ret + this.recursiveGetText(root.getChildBox(i)).trim();
        }
        return ret;
    }

    public Page getPage() {
        return this.page;
    }

    public float getUnderline() {
        return this.getBox().getVisualContext().getTextDecoration().contains(CSSProperty.TextDecoration.UNDERLINE) ? 1.0f : 0.0f;
    }

    public float getLineThrough() {
        return this.getBox().getVisualContext().getTextDecoration().contains(CSSProperty.TextDecoration.LINE_THROUGH) ? 1.0f : 0.0f;
    }

    public float getFontSize() {
        return this.getBox().getVisualContext().getFont().getSize2D();
    }

    public float getFontStyle() {
        return this.getBox().getVisualContext().getFont().isItalic() ? 1.0f : 0.0f;
    }

    public float getFontWeight() {
        return this.getBox().getVisualContext().getFont().isBold() ? 1.0f : 0.0f;
    }

    public int getX1() {
        return this.getVisualBounds().getX1();
    }

    public int getY1() {
        return this.getVisualBounds().getY1();
    }

    public int getX2() {
        return this.getVisualBounds().getX2();
    }

    public int getY2() {
        return this.getVisualBounds().getY2();
    }

    public int getWidth() {
        return this.getVisualBounds().getWidth();
    }

    public int getHeight() {
        return this.getVisualBounds().getHeight();
    }

    public Color getColor() {
        return this.getBox().getVisualContext().getColor();
    }

    public String getFontFamily() {
        return this.getBox().getVisualContext().getFont().getName();
    }

    public ContentObject getContentObject() {
        if (this.getBox().isReplaced()) {
            ReplacedContent content = ((ReplacedBox)this.getBox()).getContentObj();
            if (content instanceof ReplacedImage) {
                return new ContentImageImpl((ReplacedImage)content);
            }
            return null;
        }
        return null;
    }

    public Box.Type getType() {
        if (this.getBox().isReplaced()) {
            return Box.Type.REPLACED_CONTENT;
        }
        if (this.getBox() instanceof TextBox) {
            return Box.Type.TEXT_CONTENT;
        }
        return Box.Type.ELEMENT;
    }

    public Node getDOMNode() {
        return this.getBox().getNode();
    }

    public String getTagName() {
        Node node = this.getDOMNode();
        if (node != null && node.getNodeType() == 1) {
            return ((Element)node).getTagName().toLowerCase();
        }
        return null;
    }

    public String getAttribute(String name) {
        Node node = this.getDOMNode();
        if (node != null) {
            if ("href".equals(name)) {
                return this.getAncestorAttribute(node, "a", name);
            }
            return this.getElementAttribute(node, name);
        }
        return null;
    }

    protected String getElementAttribute(Node node, String attrName) {
        if (node.getNodeType() == 1) {
            Element el = (Element)node;
            if (el.hasAttribute(attrName)) {
                return el.getAttribute(attrName);
            }
            return null;
        }
        if (node.getNodeType() == 3) {
            Node pnode = node.getParentNode();
            if (pnode != null && pnode.getNodeType() == 1) {
                Element parent = (Element)pnode;
                if (parent.hasAttribute(attrName)) {
                    return parent.getAttribute(attrName);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    protected String getAncestorAttribute(Node node, String elementName, String attrName) {
        Node cur = node;
        while (cur.getNodeType() != 1 || !elementName.equals(cur.getNodeName())) {
            if ((cur = cur.getParentNode()) != null) continue;
            return null;
        }
        Element el = (Element)cur;
        if (el.hasAttribute(attrName)) {
            return el.getAttribute(attrName);
        }
        return null;
    }

    public Box.DisplayType getDisplayType() {
        Box box = this.getBox();
        if (box instanceof ElementBox) {
            CSSProperty.Display display = ((ElementBox)box).getDisplay();
            switch (display) {
                case BLOCK: {
                    return Box.DisplayType.BLOCK;
                }
                case INLINE: {
                    return Box.DisplayType.INLINE;
                }
                case INLINE_BLOCK: {
                    return Box.DisplayType.INLINE_BLOCK;
                }
                case INLINE_TABLE: {
                    return Box.DisplayType.INLINE_TABLE;
                }
                case LIST_ITEM: {
                    return Box.DisplayType.LIST_ITEM;
                }
                case NONE: {
                    return Box.DisplayType.NONE;
                }
                case RUN_IN: {
                    return Box.DisplayType.RUN_IN;
                }
                case TABLE: {
                    return Box.DisplayType.TABLE;
                }
                case TABLE_CAPTION: {
                    return Box.DisplayType.TABLE_CAPTION;
                }
                case TABLE_CELL: {
                    return Box.DisplayType.TABLE_CELL;
                }
                case TABLE_COLUMN: {
                    return Box.DisplayType.TABLE_COLUMN;
                }
                case TABLE_COLUMN_GROUP: {
                    return Box.DisplayType.TABLE_COLUMN_GROUP;
                }
                case TABLE_FOOTER_GROUP: {
                    return Box.DisplayType.TABLE_FOOTER_GROUP;
                }
                case TABLE_HEADER_GROUP: {
                    return Box.DisplayType.TABLE_HEADER_GROUP;
                }
                case TABLE_ROW: {
                    return Box.DisplayType.TABLE_ROW;
                }
                case TABLE_ROW_GROUP: {
                    return Box.DisplayType.TABLE_ROW_GROUP;
                }
            }
            return null;
        }
        return null;
    }
}

