/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.cssbox;

import cz.vutbr.web.css.MediaSpec;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.fit.cssbox.css.CSSNorm;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DefaultDocumentSource;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.BrowserCanvas;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.pdf.PdfBrowserCanvas;
import org.fit.layout.cssbox.BoxNode;
import org.fit.layout.cssbox.PageImpl;
import org.fit.layout.model.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CSSBoxTreeBuilder {
    private static Logger log = LoggerFactory.getLogger(CSSBoxTreeBuilder.class);
    protected URL pageUrl;
    protected PageImpl page;
    protected Dimension pageSize;
    private int order_counter;

    public CSSBoxTreeBuilder(Dimension pageSize) {
        this.pageSize = pageSize;
    }

    public void parse(URL url) throws IOException, SAXException {
        BrowserCanvas canvas = this.renderUrl(url, this.pageSize);
        PageImpl pg = this.page = new PageImpl(this.pageUrl);
        Viewport rootbox = canvas.getViewport();
        BoxNode root = this.buildTree((ElementBox)rootbox);
        pg.setRoot(root);
        pg.setWidth(rootbox.getWidth());
        pg.setHeight(rootbox.getHeight());
    }

    public void parse(String urlstring) throws MalformedURLException, IOException, SAXException {
        this.parse(new URL(urlstring));
    }

    public Page getPage() {
        return this.page;
    }

    protected BrowserCanvas renderUrl(URL url, Dimension pageSize) throws IOException, SAXException {
        int p;
        DefaultDocumentSource src = new DefaultDocumentSource(url);
        this.pageUrl = src.getURL();
        InputStream is = src.getInputStream();
        String mime = src.getContentType();
        if (mime == null) {
            mime = "text/html";
        }
        if ((p = mime.indexOf(59)) != -1) {
            mime = mime.substring(0, p).trim();
        }
        log.info("File type: " + mime);
        if (mime.equals("application/pdf")) {
            PDDocument doc = this.loadPdf(is);
            PdfBrowserCanvas canvas = new PdfBrowserCanvas(doc, null, pageSize, src.getURL());
            return canvas;
        }
        DefaultDOMSource parser = new DefaultDOMSource((DocumentSource)src);
        Document doc = parser.parse();
        String encoding = parser.getCharset();
        MediaSpec media = new MediaSpec("screen");
        DOMAnalyzer da = new DOMAnalyzer(doc, src.getURL());
        if (encoding == null) {
            encoding = da.getCharacterEncoding();
        }
        da.setDefaultEncoding(encoding);
        da.setMediaSpec(media);
        da.attributesToStyles();
        da.addStyleSheet(null, CSSNorm.stdStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.addStyleSheet(null, CSSNorm.userStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.addStyleSheet(null, CSSNorm.formsStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.getStyleSheets();
        BrowserCanvas contentCanvas = new BrowserCanvas(da.getRoot(), da, src.getURL());
        contentCanvas.getConfig().setLoadImages(false);
        contentCanvas.getConfig().setLoadBackgroundImages(false);
        contentCanvas.getConfig().setReplaceImagesWithAlt(true);
        contentCanvas.createLayout(pageSize);
        src.close();
        return contentCanvas;
    }

    private PDDocument loadPdf(InputStream is) throws IOException {
        PDDocument document = null;
        document = PDDocument.load((InputStream)is);
        if (document.isEncrypted()) {
            try {
                document.decrypt("");
            }
            catch (CryptographyException e) {
                log.error("PDF Error: Document is encrypted with a password.");
                System.exit(1);
            }
        }
        return document;
    }

    protected BoxNode buildTree(ElementBox rootbox) {
        log.trace("LIST");
        Vector<BoxNode> boxlist = new Vector<BoxNode>();
        this.order_counter = 1;
        this.createBoxList((Box)rootbox, boxlist);
        log.trace("A1");
        BoxNode root = this.createBoxTree(rootbox, boxlist, true);
        log.trace("A2");
        Color bg = rootbox.getBgcolor();
        if (bg == null) {
            bg = Color.WHITE;
        }
        this.computeBackgrounds(root, bg);
        log.trace("A2.5");
        root.recomputeVisualBounds();
        log.trace("A3");
        root = this.createBoxTree(rootbox, boxlist, false);
        root.recomputeVisualBounds();
        root.recomputeBounds();
        log.trace("A4");
        return root;
    }

    private void createBoxList(Box root, Vector<BoxNode> list) {
        if (root.isDisplayed()) {
            if (!(root instanceof Viewport) && root.isVisible() && root.getWidth() > 0 && root.getHeight() > 0) {
                BoxNode newnode = new BoxNode(root, (Page)this.page);
                newnode.setOrder(this.order_counter++);
                list.add(newnode);
            }
            if (root instanceof ElementBox) {
                ElementBox elem = (ElementBox)root;
                for (int i = elem.getStartChild(); i < elem.getEndChild(); ++i) {
                    this.createBoxList(elem.getSubBox(i), list);
                }
            }
        }
    }

    private BoxNode createBoxTree(ElementBox rootbox, Vector<BoxNode> boxlist, boolean full) {
        Iterator<BoxNode> it;
        BoxNode node2;
        Vector<BoxNode> list = new Vector<BoxNode>(boxlist);
        BoxNode root = new BoxNode((Box)rootbox, (Page)this.page);
        root.setOrder(0);
        for (BoxNode node2 : list) {
            node2.removeFromTree();
        }
        if (!full) {
            it = list.iterator();
            while (it.hasNext()) {
                node2 = it.next();
                if (node2.isVisuallySeparated() && node2.isVisible()) continue;
                it.remove();
            }
        }
        for (BoxNode node2 : list) {
            node2.markNodesInside(list, full);
        }
        it = list.iterator();
        while (it.hasNext()) {
            node2 = it.next();
            if (!node2.isRootNode()) continue;
            root.add(node2);
            it.remove();
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            root.getChildBox(i).takeChildren(list);
        }
        return root;
    }

    private void computeBackgrounds(BoxNode root, Color currentbg) {
        Color newbg = root.getBackgroundColor();
        if (newbg == null) {
            newbg = currentbg;
        }
        root.setEfficientBackground(newbg);
        root.setBackgroundSeparated(!newbg.equals(currentbg));
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.computeBackgrounds(root.getChildBox(i), newbg);
        }
    }
}

