/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.cssbox;

import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.cssbox.CSSBoxTreeBuilder;
import org.fit.layout.impl.BaseBoxTreeProvider;
import org.fit.layout.model.Page;
import org.xml.sax.SAXException;

public class CSSBoxTreeProvider
extends BaseBoxTreeProvider {
    private URL url;
    private int width;
    private int height;
    private final String[] paramNames = new String[]{"url", "width", "height"};
    private final ParametrizedOperation.ValueType[] paramTypes = new ParametrizedOperation.ValueType[]{ParametrizedOperation.ValueType.STRING, ParametrizedOperation.ValueType.INTEGER, ParametrizedOperation.ValueType.INTEGER};

    public CSSBoxTreeProvider() {
        this.url = null;
        this.width = 1200;
        this.height = 800;
    }

    public CSSBoxTreeProvider(URL url, int width, int height) {
        this.url = url;
        this.width = width;
        this.height = height;
    }

    public String getId() {
        return "FitLayout.CSSBox";
    }

    public String getName() {
        return "CSSBox HTML and PDF renderer";
    }

    public String getDescription() {
        return "Uses the CSSBox rendering engine for obtaining the box tree.";
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public ParametrizedOperation.ValueType[] getParamTypes() {
        return this.paramTypes;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setUrl(String url) {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + url);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Page getPage() {
        CSSBoxTreeBuilder build = new CSSBoxTreeBuilder(new Dimension(this.width, this.height));
        try {
            build.parse(this.url);
            return build.getPage();
        }
        catch (IOException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }
}

