/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.cssbox;

import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import org.fit.cssbox.layout.Viewport;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.cssbox.CSSBoxTreeBuilder;
import org.fit.layout.impl.BaseBoxTreeProvider;
import org.fit.layout.model.Page;
import org.xml.sax.SAXException;

public class CSSBoxTreeProvider
extends BaseBoxTreeProvider {
    private String urlstring;
    private int width;
    private int height;
    private boolean useVisualBounds;
    private boolean preserveAux;
    private boolean replaceImagesWithAlt;
    private final String[] paramNames = new String[]{"url", "width", "height", "useVisualBounds", "preserveAux"};
    private final ParametrizedOperation.ValueType[] paramTypes = new ParametrizedOperation.ValueType[]{ParametrizedOperation.ValueType.STRING, ParametrizedOperation.ValueType.INTEGER, ParametrizedOperation.ValueType.INTEGER, ParametrizedOperation.ValueType.BOOLEAN, ParametrizedOperation.ValueType.BOOLEAN};
    private CSSBoxTreeBuilder builder;

    public CSSBoxTreeProvider() {
        this.urlstring = null;
        this.width = 1200;
        this.height = 800;
        this.useVisualBounds = true;
        this.preserveAux = false;
    }

    public CSSBoxTreeProvider(URL url, int width, int height, boolean useVisualBounds, boolean preserveAux) {
        this.urlstring = url.toString();
        this.width = width;
        this.height = height;
        this.useVisualBounds = useVisualBounds;
        this.preserveAux = preserveAux;
    }

    public String getId() {
        return "FitLayout.CSSBox";
    }

    public String getName() {
        return "CSSBox HTML and PDF renderer";
    }

    public String getDescription() {
        return "Uses the CSSBox rendering engine for obtaining the box tree.";
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public ParametrizedOperation.ValueType[] getParamTypes() {
        return this.paramTypes;
    }

    public String getUrl() {
        return this.urlstring;
    }

    public void setUrl(String url) {
        this.urlstring = new String(url);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean getUseVisualBounds() {
        return this.useVisualBounds;
    }

    public void setUseVisualBounds(boolean useVisualBounds) {
        this.useVisualBounds = useVisualBounds;
    }

    public boolean getPreserveAux() {
        return this.preserveAux;
    }

    public void setPreserveAux(boolean preserveAux) {
        this.preserveAux = preserveAux;
    }

    public boolean getReplaceImagesWithAlt() {
        return this.replaceImagesWithAlt;
    }

    public void setReplaceImagesWithAlt(boolean replaceImagesWithAlt) {
        this.replaceImagesWithAlt = replaceImagesWithAlt;
    }

    public Object[] getParamRange(String name) {
        Object[] ret = new Object[2];
        switch (name) {
            case "width": 
            case "height": {
                ret[0] = 0;
                ret[1] = 9999;
                return ret;
            }
            case "url": {
                ret[0] = 0;
                ret[1] = 64;
                return ret;
            }
        }
        return super.getParamRange(name);
    }

    public Page getPage() {
        this.builder = new CSSBoxTreeBuilder(new Dimension(this.width, this.height), this.useVisualBounds, this.preserveAux, this.replaceImagesWithAlt);
        try {
            this.builder.parse(this.urlstring);
            return this.builder.getPage();
        }
        catch (IOException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Viewport getViewport() {
        if (this.builder != null) {
            return this.builder.getViewport();
        }
        return null;
    }
}

